package org.lsst.ccs.subsystem.imagehandling;

import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.daq.utilities.FitsServiceInterface;
import org.lsst.ccs.utilities.ccd.Reb;

/**
 * A Class containing Reb information and the FitsService associated to the
 * given Reb.
 * 
 * @author The LSST CCS Team
 */
class RebNode {

    private final Reb reb;
    private final FitsServiceInterface fitsService;
                
    RebNode(Reb reb, FitsServiceInterface fitsServiceForReb) {
        this.reb = reb;
        this.fitsService = fitsServiceForReb;
    }

    FitsServiceInterface getFitsService() {
        return fitsService;
    }
    
    Location getLocation() {
        return reb.getLocation();
    }
    
    Reb getReb() {
        return reb;
    }
}
