/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.subsystem.imagehandling.ShutterMotionProfileHandlerTest;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.imagehandling.data.MeasuredShutterTime;

public class PostImageFileHandlingTest {
    @Test
    public void testAdditionalFile() throws InterruptedException, ExecutionException {
        HashMap<String, String> activeSensors = new HashMap<String, String>();
        activeSensors.put("R00_SG0", "GUIDER");
        activeSensors.put("R22_S00", "SCIENCE");
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        JsonFile jf = new JsonFile("activeSensors.json", "activeSensors", imageName, "activeSensors", activeSensors);
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null);
        CompletableFuture futureLogFile = pifh.handleAdditionalFile((AdditionalFile)jf);
        CompletionStage futureProperties = futureLogFile.thenApply(logFile -> {
            Properties props = new Properties();
            try (FileReader reader = new FileReader((File)logFile);){
                props.load(reader);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            return props;
        });
        Properties props = (Properties)((CompletableFuture)futureProperties).get();
        Assert.assertEquals((Object)imageName.toString(), (Object)props.get("IMAGENAME"));
        Assert.assertEquals((Object)"activeSensors.json", (Object)props.get("FILENAME"));
        Assert.assertEquals((Object)"20230515", (Object)props.get("IMAGEDATE"));
        Assert.assertEquals((Object)"/tmp/20230515/activeSensors.json.log", (Object)props.get("LOGFILE"));
    }

    @Test
    public void testHeaderService() throws InterruptedException, ExecutionException {
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null);
        ImageName imageName = new ImageName("CC_C_20230515_000001");
        CompletableFuture<FileList> filesToProcess = new CompletableFuture<FileList>();
        CompletableFuture futureFilesWithHeaderData = pifh.handleAsynchronousData(filesToProcess, imageName, true, false);
        List headerData = Collections.emptyList();
        FileList inputFileList = new FileList();
        filesToProcess.complete(inputFileList);
        pifh.headerDataArrived(imageName, headerData);
        FileList fileList = (FileList)futureFilesWithHeaderData.get();
        Assert.assertNotNull((Object)fileList);
    }

    @Test
    public void testHeaderServiceFull() throws InterruptedException, ExecutionException, IOException, ClassNotFoundException, FitsException {
        List<CompletableFuture<FileList>> futureFilesWithHeaderDataList = this.testHeaderServiceFull("headers_MC_O_20250919_000330.ser");
        for (int i = 0; i < futureFilesWithHeaderDataList.size(); ++i) {
            FileList fileList = futureFilesWithHeaderDataList.get(i).get();
            Assert.assertNotNull((Object)fileList);
            Assert.assertEquals((long)1L, (long)fileList.size());
            File result = (File)fileList.first();
            Fits fits = new Fits(result);
            BasicHDU hdu = fits.getHDU(0);
            Header header = hdu.getHeader();
            Assert.assertEquals((Object)"FULLY", (Object)header.getStringValue("VIGNETTE"));
            Assert.assertEquals((double)-126.224348931113, (double)header.getDoubleValue("AZSTART"), (double)1.0E-5);
            Assert.assertEquals(null, (Object)header.getStringValue("HIERARCH.STUTTER.ROWS"));
            Assert.assertEquals((double)1.4315913915634155, (double)header.getDoubleValue("SEEING"), (double)1.0E-5);
        }
    }

    @Test
    public void testHeaderServiceFullWithNaN() throws InterruptedException, ExecutionException, IOException, ClassNotFoundException, FitsException {
        List<CompletableFuture<FileList>> futureFilesWithHeaderDataList = this.testHeaderServiceFull("headers_MC_O_20251026_000414.ser");
        for (int i = 0; i < futureFilesWithHeaderDataList.size(); ++i) {
            FileList fileList = futureFilesWithHeaderDataList.get(i).get();
            Assert.assertNotNull((Object)fileList);
            Assert.assertEquals((long)1L, (long)fileList.size());
            File result = (File)fileList.first();
            Fits fits = new Fits(result);
            BasicHDU hdu = fits.getHDU(0);
            Header header = hdu.getHeader();
            Assert.assertEquals((Object)"NO", (Object)header.getStringValue("VIGNETTE"));
            Assert.assertEquals((double)-179.928283, (double)header.getDoubleValue("AZSTART"), (double)1.0E-5);
            Assert.assertEquals(null, (Object)header.getStringValue("HIERARCH.STUTTER.ROWS"));
            Assert.assertEquals((double)0.0, (double)header.getDoubleValue("SEEING"), (double)1.0E-5);
        }
    }

    private List<CompletableFuture<FileList>> testHeaderServiceFull(String headerServiceData) throws InterruptedException, ExecutionException, IOException, ClassNotFoundException, FitsException {
        List headerData;
        FitsFactory.setUseHierarch((boolean)true);
        Path inFile = new File("/home/tonyj/Data/MC_C_20251020_000140_R34_S22.fits").toPath();
        Assume.assumeTrue((boolean)Files.exists(inFile, new LinkOption[0]));
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        final AtomicBoolean wasCalled = new AtomicBoolean(false);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null){

            void fixupFitsFiles(FileList fileList, List<ImageHeaderData.Header> headerData, boolean overwrite, ImageName imageName) throws FitsException, IOException {
                super.fixupFitsFiles(fileList, headerData, overwrite, imageName);
                wasCalled.set(true);
            }
        };
        ImageName imageName = new ImageName("MC_O_20250919_000330");
        int nFiles = 5;
        ArrayList<File> outputFilesWithHeaders = new ArrayList<File>();
        ArrayList filesToProcessList = new ArrayList();
        ArrayList<CompletableFuture<FileList>> futureFilesWithHeaderDataList = new ArrayList<CompletableFuture<FileList>>();
        for (int i = 0; i < nFiles; ++i) {
            Path outFile = new File("/home/tonyj/Data/MC_C_20251020_000140_R34_S22_with_headers_" + i + ".fits").toPath();
            Files.copy(inFile, outFile, StandardCopyOption.REPLACE_EXISTING);
            outputFilesWithHeaders.add(outFile.toFile());
            CompletableFuture filesToProcess = new CompletableFuture();
            filesToProcessList.add(filesToProcess);
            futureFilesWithHeaderDataList.add(pifh.handleAsynchronousData(filesToProcess, imageName, true, false));
        }
        try (ObjectInputStream in = new ObjectInputStream(PostImageFileHandling.class.getResourceAsStream(headerServiceData));){
            headerData = (List)in.readObject();
        }
        for (int i = 0; i < nFiles; ++i) {
            FileList inputFileList = new FileList();
            inputFileList.add((Object)((File)outputFilesWithHeaders.get(i)));
            ((CompletableFuture)filesToProcessList.get(i)).complete(inputFileList);
        }
        Assert.assertFalse((boolean)wasCalled.get());
        pifh.headerDataArrived(imageName, headerData);
        Assert.assertTrue((boolean)wasCalled.get());
        pifh.completePostImageFileHandlingForImage(imageName);
        return futureFilesWithHeaderDataList;
    }

    @Test
    public void testMeasuredShutterTime() throws InterruptedException, ExecutionException {
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        final AtomicBoolean wasCalled = new AtomicBoolean(false);
        final ImageName inputImageName = new ImageName("MC_C_20230515_000001");
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null){

            FileList mergeShutterTimeData(ImageName imageName, FileList fl, Double measuredShutterTime) {
                wasCalled.set(true);
                Assert.assertEquals((Object)inputImageName, (Object)imageName);
                return fl;
            }
        };
        CompletableFuture<FileList> filesToProcess = new CompletableFuture<FileList>();
        CompletableFuture futureFilesWithHeaderData = pifh.handleAsynchronousData(filesToProcess, inputImageName, false, true);
        FileList inputFileList = new FileList();
        filesToProcess.complete(inputFileList);
        MeasuredShutterTime shutterTime = new MeasuredShutterTime(inputImageName, 0.0);
        pifh.measuredShutterTimeArrived(shutterTime);
        FileList fileList = (FileList)futureFilesWithHeaderData.get();
        Assert.assertNotNull((Object)fileList);
        Assert.assertTrue((boolean)wasCalled.get());
    }

    @Test
    public void testMeasuredShutterTimeAndShutterMotionProfiles() throws InterruptedException, ExecutionException, IOException, FitsException {
        FitsFactory.setUseHierarch((boolean)true);
        Path inFile = new File("/home/tonyj/Data/MC_C_20251020_000140_R34_S22.fits").toPath();
        Assume.assumeTrue((boolean)Files.exists(inFile, new LinkOption[0]));
        Path outFile = new File("/home/tonyj/Data/MC_C_20251020_000140_R34_S22_with_headers.fits").toPath();
        Files.copy(inFile, outFile, StandardCopyOption.REPLACE_EXISTING);
        File dataFile = outFile.toFile();
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        final AtomicBoolean wasCalled = new AtomicBoolean(false);
        final ImageName inputImageName = new ImageName("MC_C_20230515_000001");
        String openString = new String(ShutterMotionProfileHandlerTest.class.getResourceAsStream("MC_C_20251017_000031_shutterMotionProfileOpen.json").readAllBytes());
        String closeString = new String(ShutterMotionProfileHandlerTest.class.getResourceAsStream("MC_C_20251017_000031_shutterMotionProfileClose.json").readAllBytes());
        final JsonFile openFile = this.createJsonFile(openString, inputImageName);
        final JsonFile closeFile = this.createJsonFile(closeString, inputImageName);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null){

            FileList mergeShutterMotionProfiles(ImageName imageName, FileList fl, List<JsonFile> jsonFiles) {
                wasCalled.set(true);
                Assert.assertEquals((long)2L, (long)jsonFiles.size());
                Assert.assertEquals((Object)openFile, (Object)jsonFiles.get(0));
                Assert.assertEquals((Object)closeFile, (Object)jsonFiles.get(1));
                Assert.assertEquals((Object)inputImageName, (Object)imageName);
                super.mergeShutterMotionProfiles(imageName, fl, jsonFiles);
                return fl;
            }
        };
        CompletableFuture<FileList> filesToProcess = new CompletableFuture<FileList>();
        CompletableFuture futureFilesWithHeaderData = pifh.handleAsynchronousData(filesToProcess, inputImageName, false, true);
        FileList inputFileList = new FileList();
        inputFileList.add((Object)dataFile);
        filesToProcess.complete(inputFileList);
        MeasuredShutterTime shutterTime = new MeasuredShutterTime(inputImageName, 10.0);
        pifh.measuredShutterTimeArrived(shutterTime);
        pifh.shutterMotionProfileArrived(openFile);
        pifh.shutterMotionProfileArrived(closeFile);
        FileList fileList = (FileList)futureFilesWithHeaderData.get();
        Assert.assertTrue((boolean)wasCalled.get());
        Assert.assertNotNull((Object)fileList);
        Assert.assertEquals((long)1L, (long)fileList.size());
        Fits fits = new Fits((File)fileList.first());
        BasicHDU primary = fits.getHDU(0);
        Header primaryHeader = primary.getHeader();
        Assert.assertEquals((Object)"MINUSX", (Object)primaryHeader.getStringValue("HIERARCH.SHUTTER.OPEN.SIDE"));
        Assert.assertEquals((Object)"PLUSX", (Object)primaryHeader.getStringValue("HIERARCH.SHUTTER.CLOSE.SIDE"));
        Assert.assertEquals((double)60965.62693945039, (double)primaryHeader.getDoubleValue("HIERARCH.SHUTTER.OPEN.STARTTIME.TAI.MJD"), (double)1.0E-5);
    }

    private JsonFile createJsonFile(String openString, ImageName imageName) throws JsonProcessingException, NumberFormatException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap readValue = (HashMap)mapper.readValue(openString, (TypeReference)typeRef);
        JsonFile openFile = new JsonFile(readValue.get("fileName").toString(), readValue.get("fileType").toString(), imageName, "motionProfile", readValue.get("motionProfile"));
        openFile.setVersion(Float.parseFloat(readValue.get("version").toString()));
        return openFile;
    }
}

