/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.imagehandling.ShutterMotionProfileHandler;

public class ShutterMotionProfileHandlerTest {
    @BeforeEach
    public void setUp() {
        FitsFactory.setUseHierarch((boolean)true);
    }

    @Test
    public void testMain() throws IOException, FitsException {
        Path outPath = Files.createTempFile("shutterMotionProfile", ".fits", new FileAttribute[0]);
        String openString = new String(ShutterMotionProfileHandlerTest.class.getResourceAsStream("MC_O_20250413_000480_shutterMotionProfileOpen.json").readAllBytes());
        String closeString = new String(ShutterMotionProfileHandlerTest.class.getResourceAsStream("MC_O_20250413_000480_shutterMotionProfileClose.json").readAllBytes());
        Header primHeader = new Header();
        primHeader.addValue("SIMPLE", true, "conforms to FITS standard");
        primHeader.addValue("BITPIX", 8L, "array data type");
        primHeader.addValue("NAXIS", 0L, "number of array dimensions");
        primHeader.addValue("EXTEND", true, null);
        primHeader.addValue("COMMENT", "Dummy primary HDU for shutter motion profiles", null);
        primHeader.addValue("OBSID", "MC_O_20250413_000480", null);
        ImageHDU primary = new ImageHDU(primHeader, null);
        BinaryTableHDU openHDU = ShutterMotionProfileHandler.createHDU((String)openString);
        BinaryTableHDU closeHDU = ShutterMotionProfileHandler.createHDU((String)closeString);
        String openside = openHDU.getHeader().getStringValue("HIERARCH.SHUTTER.SIDE");
        Assert.assertEquals((Object)"PLUSX", (Object)openside);
        Fits fits = new Fits();
        fits.addHDU((BasicHDU)primary);
        try (BufferedFile bf = new BufferedFile(outPath.toString(), "rw");){
            fits.write((DataOutput)bf);
        }
        ShutterMotionProfileHandler.appendHDUsToFitsFile((File)outPath.toFile(), (BinaryTableHDU)openHDU, (BinaryTableHDU)closeHDU);
        System.out.println("Wrote " + outPath);
        System.out.printf("Extensions: %s (%d rows), %s (%d rows)%n", openHDU.getHeader().getStringValue("EXTNAME"), ((BinaryTable)openHDU.getData()).getNRows(), closeHDU.getHeader().getStringValue("EXTNAME"), ((BinaryTable)closeHDU.getData()).getNRows());
        Assert.assertEquals((Object)"OPEN", (Object)openHDU.getHeader().getStringValue("EXTNAME"));
        Assert.assertEquals((long)366L, (long)((BinaryTable)openHDU.getData()).getNRows());
        Assert.assertEquals((Object)"CLOSE", (Object)closeHDU.getHeader().getStringValue("EXTNAME"));
        Assert.assertEquals((long)366L, (long)((BinaryTable)closeHDU.getData()).getNRows());
        Assert.assertEquals((long)54720L, (long)Files.size(outPath));
    }

    @Test
    public void testMainV2() throws IOException, FitsException {
        Path outPath = Files.createTempFile("shutterMotionProfile", ".fits", new FileAttribute[0]);
        String openString = new String(ShutterMotionProfileHandlerTest.class.getResourceAsStream("MC_C_20251017_000031_shutterMotionProfileOpen.json").readAllBytes());
        String closeString = new String(ShutterMotionProfileHandlerTest.class.getResourceAsStream("MC_C_20251017_000031_shutterMotionProfileClose.json").readAllBytes());
        Header primHeader = new Header();
        primHeader.addValue("SIMPLE", true, "conforms to FITS standard");
        primHeader.addValue("BITPIX", 8L, "array data type");
        primHeader.addValue("NAXIS", 0L, "number of array dimensions");
        primHeader.addValue("EXTEND", true, null);
        primHeader.addValue("COMMENT", "Dummy primary HDU for shutter motion profiles", null);
        primHeader.addValue("OBSID", "MC_O_20251017_000031", null);
        ImageHDU primary = new ImageHDU(primHeader, null);
        BinaryTableHDU openHDU = ShutterMotionProfileHandler.createHDU((String)openString);
        BinaryTableHDU closeHDU = ShutterMotionProfileHandler.createHDU((String)closeString);
        String openside = openHDU.getHeader().getStringValue("HIERARCH.SHUTTER.SIDE");
        Assert.assertEquals((Object)"MINUSX", (Object)openside);
        Fits fits = new Fits();
        fits.addHDU((BasicHDU)primary);
        try (BufferedFile bf = new BufferedFile(outPath.toString(), "rw");){
            fits.write((DataOutput)bf);
        }
        ShutterMotionProfileHandler.appendHDUsToFitsFile((File)outPath.toFile(), (BinaryTableHDU)openHDU, (BinaryTableHDU)closeHDU);
        System.out.println("Wrote " + outPath);
        System.out.printf("Extensions: %s (%d rows), %s (%d rows)%n", openHDU.getHeader().getStringValue("EXTNAME"), ((BinaryTable)openHDU.getData()).getNRows(), closeHDU.getHeader().getStringValue("EXTNAME"), ((BinaryTable)closeHDU.getData()).getNRows());
        Assert.assertEquals((Object)"OPEN", (Object)openHDU.getHeader().getStringValue("EXTNAME"));
        Assert.assertEquals((long)366L, (long)((BinaryTable)openHDU.getData()).getNRows());
        Assert.assertEquals((Object)"CLOSE", (Object)closeHDU.getHeader().getStringValue("EXTNAME"));
        Assert.assertEquals((long)366L, (long)((BinaryTable)closeHDU.getData()).getNRows());
        Assert.assertEquals((long)54720L, (long)Files.size(outPath));
    }
}

