package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;

/**
 * A configurable service for connecting to a database for recording images.
 *
 * @author tonyj
 */
@SuppressWarnings("FieldMayBeFinal")
public class ImageDatabaseService implements HasLifecycle {

    private static final Logger LOG = Logger.getLogger(ImageDatabaseService.class.getName());

    @ConfigurationParameter(isFinal = true, units = "unitless", description = "Image Database URL")
    private volatile String dbURL;

    @ConfigurationParameter(isFinal = true, units = "unitless", description = "true/false Image Database enable flag")
    private volatile boolean enabled = true;

    private Connection conn;

    /**
     * Create a test instance of the ImageDatabaseService
     *
     * @param dbURL The dbURL to use
     * @return The created and initialized ImageNameService
     */
    public static ImageDatabaseService testInstance(String dbURL) {
        ImageDatabaseService idbs = new ImageDatabaseService();
        idbs.dbURL = dbURL;
        return idbs;
    }

    @Override
    public void shutdown() {
        closeConnection();
    }

    synchronized Connection openConnection() throws SQLException {
        if (enabled && (conn == null || conn.isClosed())) {
            conn = DriverManager.getConnection(dbURL);
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        }
        return conn;
    }

    synchronized void closeConnection() {
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException ex) {
                LOG.log(Level.SEVERE, "Error closing image database", ex);
            }
            conn = null;
        }
    }

}
