/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;

public class ShutterMotionProfileHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final LinkedHashMap<String, String> HEADER_FIELD_MAP = new LinkedHashMap();
    private static final String HIERARCH_PREFIX = "HIERARCH SHUTTER ";

    static BinaryTableHDU createHDU(String json) throws JsonProcessingException, FitsException {
        JsonNode doc = MAPPER.readTree(json);
        String version = ShutterMotionProfileHandler.findVersion(doc);
        JsonNode profile = ShutterMotionProfileHandler.safeNode(doc, "motionProfile");
        boolean open = profile.path("isOpen").asBoolean(true);
        JsonNode fitResults = ShutterMotionProfileHandler.safeNode(profile, "fitResults");
        BinaryTableHDU hdu = ShutterMotionProfileHandler.buildCombinedTableHDU(profile, fitResults, open ? "OPEN" : "CLOSE", version);
        return hdu;
    }

    static void appendHDUsToFitsFile(File file, BinaryTableHDU openHDU, BinaryTableHDU closeHDU) throws IOException, FitsException {
        try (BufferedFile bf2 = new BufferedFile(file, "rw");){
            bf2.seek(bf2.length());
            openHDU.write((ArrayDataOutput)bf2);
            closeHDU.write((ArrayDataOutput)bf2);
        }
    }

    private static BinaryTableHDU buildCombinedTableHDU(JsonNode profile, JsonNode fitResults, String extname, String version) throws FitsException {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (JsonNode s : ShutterMotionProfileHandler.safeArray(profile, "encodeSamples")) {
            rows.add(Row.fromEncode(s, version));
        }
        for (JsonNode h : ShutterMotionProfileHandler.safeArray(profile, "hallTransitions")) {
            rows.add(Row.fromHall(h, version));
        }
        int n = rows.size();
        String[] TYPE = new String[n];
        String[] TIME_TAI = new String[n];
        double[] TIME_MJD = new double[n];
        double[] POSITION = new double[n];
        String[] SENSORID = new String[n];
        boolean[] ISON = new boolean[n];
        int maxType = 4;
        int maxTai = 1;
        int maxSid = 1;
        for (int i = 0; i < n; ++i) {
            Row r = (Row)rows.get(i);
            TYPE[i] = r.TYPE;
            TIME_TAI[i] = r.TIME_TAI;
            TIME_MJD[i] = r.TIME_MJD;
            POSITION[i] = r.POSITION;
            SENSORID[i] = r.SENSORID == -1 ? "" : String.valueOf(r.SENSORID);
            ISON[i] = r.ISON;
            maxType = Math.max(maxType, TYPE[i] == null ? 0 : TYPE[i].length());
            maxTai = Math.max(maxTai, TIME_TAI[i] == null ? 0 : TIME_TAI[i].length());
            maxSid = Math.max(maxSid, SENSORID[i] == null ? 0 : SENSORID[i].length());
        }
        Object[] dataCols = new Object[]{TYPE, TIME_TAI, TIME_MJD, POSITION, SENSORID, ISON};
        int naxis1 = 17 + maxType + maxTai + maxSid;
        BinaryTable bt = new BinaryTable(dataCols);
        BinaryTableHDU hdu = new BinaryTableHDU(new Header(), bt);
        Header header = hdu.getHeader();
        header.addValue("XTENSION", "BINTABLE", "binary table extension");
        header.addValue("BITPIX", 8L, "array data type");
        header.addValue("NAXIS", 2L, "number of array dimensions");
        header.addValue("NAXIS1", (long)naxis1, "number of array dimensions");
        header.addValue("NAXIS2", (long)n, "number of array dimensions");
        header.addValue("PCOUNT", 0L, "number of group parameters");
        header.addValue("GCOUNT", 1L, "number of groups");
        header.addValue("TFIELDS", 6L, "number of table fields");
        ShutterMotionProfileHandler.setColumnMeta(hdu, 1, "TYPE", null, "Row type: 'ENCODE' (encoder sample) or 'HALL' (hall transition)");
        ShutterMotionProfileHandler.setColumnMeta(hdu, 2, "TIME_TAI", "ISOT", "ISO-8601 time (TAI) as provided in JSON");
        ShutterMotionProfileHandler.setColumnMeta(hdu, 3, "TIME_MJD", "d", "Modified Julian Date (TAI) as provided in JSON");
        ShutterMotionProfileHandler.setColumnMeta(hdu, 4, "POSITION", "mm", "Shutter position");
        ShutterMotionProfileHandler.setColumnMeta(hdu, 5, "SENSORID", null, "Hall sensor identifier (empty for ENCODE rows)");
        ShutterMotionProfileHandler.setColumnMeta(hdu, 6, "ISON", null, "Hall state: True if sensor ON; False otherwise");
        ShutterMotionProfileHandler.setTFORM(header, 1, "A" + Math.max(maxType, 1));
        ShutterMotionProfileHandler.setTFORM(header, 2, "A" + Math.max(maxTai, 1));
        ShutterMotionProfileHandler.setTFORM(header, 3, "D");
        ShutterMotionProfileHandler.setTFORM(header, 4, "D");
        ShutterMotionProfileHandler.setTFORM(header, 5, "A" + Math.max(maxSid, 1));
        ShutterMotionProfileHandler.setTFORM(header, 6, "L");
        header.addValue("EXTNAME", extname, "extension name");
        LinkedHashMap<String, String> headerFieldMap = HEADER_FIELD_MAP;
        if ("1.0".equals(version)) {
            headerFieldMap = new LinkedHashMap<String, String>(headerFieldMap);
            headerFieldMap.put("STARTTIME TAI ISOT", "startTime.tai");
            headerFieldMap.put("STARTTIME TAI MJD", "startTime.mjd");
        }
        ShutterMotionProfileHandler.addMotionProfileHeaders(header, profile, headerFieldMap);
        ShutterMotionProfileHandler.addFitResultsHeaders(header, fitResults);
        return hdu;
    }

    private static void setTFORM(Header hdr, int colIndex1Based, String tform) throws HeaderCardException {
        String key = "TFORM" + colIndex1Based;
        if (hdr.findCard(key) != null) {
            hdr.findCard(key).setValue(tform);
        } else {
            hdr.addValue(key, tform, "column data format");
        }
    }

    private static void addMotionProfileHeaders(Header hdr, JsonNode profile, Map<String, String> headerFieldMap) throws HeaderCardException {
        for (Map.Entry<String, String> e : headerFieldMap.entrySet()) {
            String suffix = e.getKey();
            String jsonPath = e.getValue();
            JsonNode vNode = ShutterMotionProfileHandler.getByPath(profile, jsonPath);
            String key = HIERARCH_PREFIX + suffix;
            if (vNode != null && !vNode.isMissingNode() && !vNode.isNull()) {
                Object value = ShutterMotionProfileHandler.jsonNodeToScalar(vNode);
                ShutterMotionProfileHandler.addHierarch(hdr, key, value, null);
                continue;
            }
            ShutterMotionProfileHandler.addHierarch(hdr, key, "", null);
        }
    }

    private static void addFitResultsHeaders(Header hdr, JsonNode fitResults) throws HeaderCardException {
        if (fitResults == null || fitResults.isMissingNode() || fitResults.isNull()) {
            return;
        }
        ArrayList<FlatEntry> flat = new ArrayList<FlatEntry>();
        ShutterMotionProfileHandler.flatten("", fitResults, flat);
        int fallbackIdx = 0;
        for (FlatEntry fe : flat) {
            String path = fe.path.startsWith("fitResults.") ? fe.path.substring("fitResults.".length()) : fe.path;
            String suffix = ShutterMotionProfileHandler.suffixFromPath(path);
            String key = HIERARCH_PREFIX + suffix;
            try {
                ShutterMotionProfileHandler.addHierarch(hdr, key, fe.value, null);
            }
            catch (HeaderCardException ex) {
                String kVal = "HIERARCH SHUTTER FITRES" + ++fallbackIdx;
                String kName = "HIERARCH SHUTTER FITRES" + fallbackIdx + " NAME";
                ShutterMotionProfileHandler.addHierarch(hdr, kVal, fe.value, null);
                ShutterMotionProfileHandler.addHierarch(hdr, kName, fe.path, null);
            }
        }
    }

    private static void addHierarch(Header hdr, String keyword, Object value, String comment) throws HeaderCardException {
        keyword = keyword.replaceAll(" ", ".");
        if (value == null) {
            value = "";
        }
        if (value instanceof Double) {
            Double aDouble = (Double)value;
            hdr.addValue(keyword, aDouble.doubleValue(), comment);
        } else if (value instanceof Boolean) {
            Boolean aBoolean = (Boolean)value;
            hdr.addValue(keyword, aBoolean.booleanValue(), comment);
        } else {
            hdr.addValue(keyword, String.valueOf(value), comment);
        }
    }

    private static String suffixFromPath(String path) {
        String[] parts = path.split("[^A-Za-z0-9]+");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(p.toUpperCase());
        }
        return sb.toString();
    }

    private static void setColumnMeta(BinaryTableHDU hdu, int colIndex1Based, String name, String unit, String ttypeComment) throws HeaderCardException {
        String ttypeKey;
        Header hdr = hdu.getHeader();
        if (hdr.findCard(ttypeKey = "TTYPE" + colIndex1Based) != null) {
            hdr.findCard(ttypeKey).setValue(name);
            hdr.findCard(ttypeKey).setComment(ttypeComment);
        } else {
            hdr.addValue(ttypeKey, name, ttypeComment);
        }
        if (unit != null && !unit.isEmpty()) {
            String tunitKey = "TUNIT" + colIndex1Based;
            if (hdr.findCard(tunitKey) != null) {
                hdr.findCard(tunitKey).setValue(unit);
                hdr.findCard(tunitKey).setComment(ShutterMotionProfileHandler.unitCommentFor(unit, name));
            } else {
                hdr.addValue(tunitKey, unit, ShutterMotionProfileHandler.unitCommentFor(unit, name));
            }
        }
    }

    private static String unitCommentFor(String unit, String colName) {
        return switch (unit) {
            case "ISOT" -> "Time scale indicator for " + colName + " ('ISOT')";
            case "d" -> "Days";
            case "mm" -> "Millimetres";
            default -> null;
        };
    }

    private static JsonNode safeNode(JsonNode root, String field) {
        return root != null && root.has(field) ? root.get(field) : MAPPER.createObjectNode();
    }

    private static List<JsonNode> safeArray(JsonNode root, String field) {
        if (root != null && root.has(field) && root.get(field).isArray()) {
            ArrayList<JsonNode> list = new ArrayList<JsonNode>();
            root.get(field).forEach(list::add);
            return list;
        }
        return Collections.emptyList();
    }

    private static JsonNode getByPath(JsonNode node, String dotPath) {
        if (node == null) {
            return null;
        }
        String[] parts = dotPath.split("\\.");
        JsonNode cur = node;
        for (String p : parts) {
            if (cur == null || cur.isMissingNode()) {
                return null;
            }
            cur = cur.get(p);
        }
        return cur;
    }

    private static Object jsonNodeToScalar(JsonNode node) {
        if (node == null || node.isNull()) {
            return "";
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isInt() || node.isLong()) {
            return node.asLong();
        }
        if (node.isFloat() || node.isDouble() || node.isBigDecimal()) {
            return node.asDouble();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.toString();
    }

    private static String findObsid(JsonNode doc) {
        HashSet<String> keys = new HashSet<String>(Arrays.asList("obsid", "observationid", "obs_id", "obsidstr", "obsId"));
        ArrayDeque<JsonNode> stack = new ArrayDeque<JsonNode>();
        stack.push(doc);
        while (!stack.isEmpty()) {
            JsonNode cur = (JsonNode)stack.pop();
            if (cur.isObject()) {
                Iterator it = cur.fields();
                while (it.hasNext()) {
                    Map.Entry e = (Map.Entry)it.next();
                    if (keys.contains(((String)e.getKey()).toLowerCase(Locale.ROOT))) {
                        return ((JsonNode)e.getValue()).asText();
                    }
                    JsonNode v = (JsonNode)e.getValue();
                    if (!v.isContainerNode()) continue;
                    stack.push(v);
                }
                continue;
            }
            if (!cur.isArray()) continue;
            cur.forEach(stack::push);
        }
        return null;
    }

    private static String findVersion(JsonNode doc) {
        HashSet<String> keys = new HashSet<String>(Arrays.asList("version"));
        ArrayDeque<JsonNode> stack = new ArrayDeque<JsonNode>();
        stack.push(doc);
        while (!stack.isEmpty()) {
            JsonNode cur = (JsonNode)stack.pop();
            if (cur.isObject()) {
                Iterator it = cur.fields();
                while (it.hasNext()) {
                    Map.Entry e = (Map.Entry)it.next();
                    if (keys.contains(((String)e.getKey()).toLowerCase(Locale.ROOT))) {
                        return ((JsonNode)e.getValue()).asText();
                    }
                    JsonNode v = (JsonNode)e.getValue();
                    if (!v.isContainerNode()) continue;
                    stack.push(v);
                }
                continue;
            }
            if (!cur.isArray()) continue;
            cur.forEach(stack::push);
        }
        return null;
    }

    private static void flatten(String prefix, JsonNode node, List<FlatEntry> out) {
        if (node == null || node.isNull()) {
            return;
        }
        if (node.isObject()) {
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                String path = prefix.isEmpty() ? (String)e.getKey() : prefix + "." + (String)e.getKey();
                ShutterMotionProfileHandler.flatten(path, (JsonNode)e.getValue(), out);
            }
        } else if (node.isArray()) {
            out.add(new FlatEntry(prefix, node.toString()));
        } else {
            out.add(new FlatEntry(prefix, ShutterMotionProfileHandler.jsonNodeToScalar(node)));
        }
    }

    static {
        HEADER_FIELD_MAP.put("STARTTIME TAI ISOT", "startTime.tai.isot");
        HEADER_FIELD_MAP.put("STARTTIME TAI MJD", "startTime.tai.mjd");
        HEADER_FIELD_MAP.put("STARTPOSITION", "startPosition");
        HEADER_FIELD_MAP.put("TARGETPOSITION", "targetPosition");
        HEADER_FIELD_MAP.put("ENDPOSITION", "endPosition");
        HEADER_FIELD_MAP.put("TARGETDURATION", "targetDuration");
        HEADER_FIELD_MAP.put("ACTIONDURATION", "actionDuration");
        HEADER_FIELD_MAP.put("SIDE", "side");
    }

    private static class Row {
        final String TYPE;
        final String TIME_TAI;
        final double TIME_MJD;
        final double POSITION;
        final int SENSORID;
        final boolean ISON;

        Row(String type, String tai, double mjd, double position, Integer sensorId, boolean isOn) {
            this.TYPE = type == null ? "" : type;
            this.TIME_TAI = tai == null ? "" : tai;
            this.TIME_MJD = Double.isNaN(mjd) ? Double.NaN : mjd;
            this.POSITION = Double.isNaN(position) ? Double.NaN : position;
            this.SENSORID = sensorId == null ? -1 : sensorId;
            this.ISON = isOn;
        }

        static Row fromEncode(JsonNode s, String version) {
            String taiPath = "tai.isot";
            String mjdPath = "tai.mjd";
            if ("1.0".contains(version)) {
                taiPath = "time.tai";
                mjdPath = "time.mjd";
            }
            String tai = Row.optText(ShutterMotionProfileHandler.getByPath(s, taiPath), "");
            Double mjd = Row.optDouble(ShutterMotionProfileHandler.getByPath(s, mjdPath));
            Double pos = Row.optDouble(s.get("position"));
            return new Row("ENCODE", tai, mjd != null ? mjd : Double.NaN, pos != null ? pos : Double.NaN, -1, false);
        }

        static Row fromHall(JsonNode h, String version) {
            String taiPath = "tai.isot";
            String mjdPath = "tai.mjd";
            if ("1.0".contains(version)) {
                taiPath = "time.tai";
                mjdPath = "time.mjd";
            }
            String tai = Row.optText(ShutterMotionProfileHandler.getByPath(h, taiPath), "");
            Double mjd = Row.optDouble(ShutterMotionProfileHandler.getByPath(h, mjdPath));
            Double pos = Row.optDouble(h.get("position"));
            int sensorId = Row.optInteger(h.get("sensorId"));
            boolean isOn = Row.optBool(h.get("isOn"), false);
            return new Row("HALL", tai, mjd != null ? mjd : Double.NaN, pos != null ? pos : Double.NaN, sensorId, isOn);
        }

        private static String optText(JsonNode n, String def) {
            return n != null && n.isTextual() ? n.asText() : def;
        }

        private static Double optDouble(JsonNode n) {
            return n != null && n.isNumber() ? Double.valueOf(n.asDouble()) : null;
        }

        private static Integer optInteger(JsonNode n) {
            return n != null && n.isNumber() ? Integer.valueOf(n.asInt()) : null;
        }

        private static boolean optBool(JsonNode n, boolean def) {
            return n != null && n.isBoolean() ? n.asBoolean() : def;
        }
    }

    private static class FlatEntry {
        final String path;
        final Object value;

        FlatEntry(String path, Object value) {
            this.path = path;
            this.value = value;
        }
    }
}

