/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageFileDatabase;
import org.lsst.ccs.utilities.location.SensorLocation;

public class DatabaseTest {
    static String createConnection() {
        return "jdbc:h2:mem:test;MODE=MYSQL";
    }

    @Test
    public void testImageDatabase() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)DatabaseTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001309");
            SensorLocation location = new SensorLocation(2, 2, 2);
            int file_id = ifdb.insertFile(in, location, "TYPE", "TEST_FILE");
            PreparedStatement stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file");
            ResultSet rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)"TYPE", (Object)rs.getString("fileType"));
            Assert.assertEquals((Object)"TEST_FILE", (Object)rs.getString("writeFile"));
            float dummy_elapsed = 11232.1f;
            ImageFileDatabase.Operation operation = new ImageFileDatabase.Operation(file_id, "SMOOTH", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file_operation where file_id = ?");
            stmt.setInt(1, file_id);
            rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)true, (Object)rs.getBoolean("success"));
            Assert.assertEquals((Object)"SMOOTH", (Object)rs.getString("operation"));
        }
    }

    @Test
    public void testNoSensorDatabase() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)DatabaseTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001309");
            SensorLocation location = null;
            int file_id = ifdb.insertFile(in, location, "TYPE", "TEST_FILE");
            PreparedStatement stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file where file_id = ?");
            stmt.setInt(1, file_id);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)"NR", (Object)rs.getString("raft"));
            Assert.assertEquals((Object)"NS", (Object)rs.getString("sensor"));
        }
    }
}

