/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.utilities.ccd.FocalPlane;

public class ImageHandlerTest {
    @Test
    public void testAlerts() throws Exception {
        Agent a = new Agent("a", AgentInfo.AgentType.WORKER);
        a.startAgent();
        ((AgentStateService)a.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
        AlertService alertService = (AlertService)a.getAgentService(AlertService.class);
        FocalPlane fp = new FocalPlane("");
        ImageHandlingClient ihClient = new ImageHandlingClient(fp);
        ihClient.registerAlerts(alertService);
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, alertService);
        config.raiseAlertOnMissingOrBadHeaderServiceData = false;
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().isEmpty());
        ImageName imageName = new ImageName("MC_C_20250428_000001");
        pifh.mergeHeaderServiceData(imageName, null, null);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().isEmpty());
        config.raiseAlertOnMissingOrBadHeaderServiceData = true;
        pifh.mergeHeaderServiceData(imageName, null, null);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.ALARM ? 1 : 0) != 0);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getRaisedAlert("missingHeaders") != null ? 1 : 0) != 0);
        alertService.clearAlerts(new String[]{"missingHeaders"});
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().isEmpty());
        a.shutdownAgent();
    }
}

