/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentService;

public class PulseService
implements ServiceLifecycle,
HasLifecycle,
AgentMonitor,
AgentService {
    private static final String STATUS_OK = "OK";
    private static final long PERIOD = 1000L;
    private static final long VETO_TIME = 60000L;
    private static final long VETO_FACTOR = 2L;
    private final ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        private final ThreadFactory f = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.f.newThread(r);
            t.setDaemon(true);
            t.setName(PulseService.this.getAgentServiceName());
            return t;
        }
    });
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private ScheduledFuture<?> checkTask;
    private long prevTime = System.currentTimeMillis() + 3600000L;
    private long prevDelay;
    private long prevWarnTime;
    private volatile String status = "OK";

    @Override
    public void start() {
        this.checkTask = this.exec.scheduleWithFixedDelay(this::check, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.checkTask.cancel(true);
        this.exec.shutdownNow();
    }

    @Override
    public String getAgentMonitorStatus(boolean useCcsBuses) {
        return this.status;
    }

    @Override
    public String getAgentMonitorDescription() {
        return "Pulse. ";
    }

    @Override
    public String getAgentServiceName() {
        return "pulseService";
    }

    private void check() {
        long time = System.currentTimeMillis();
        long delay = time - this.prevTime - 1000L;
        if (delay > 1000L) {
            if (time - this.prevWarnTime > 60000L || delay > this.prevDelay * 2L) {
                Object rt2;
                StringBuilder sb = new StringBuilder();
                sb.append("PULSE: delay ").append(delay);
                try {
                    rt2 = ManagementFactory.getRuntimeMXBean();
                    long now = rt2.getUptime();
                    sb.append(". GC: ");
                    boolean hasGC = false;
                    for (java.lang.management.GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                        GcInfo info;
                        if (!(gc instanceof GarbageCollectorMXBean) || (info = ((GarbageCollectorMXBean)gc).getLastGcInfo()) == null) continue;
                        sb.append(gc.getName()).append(" from ").append(info.getStartTime() - now).append(" to ").append(info.getEndTime() - now).append(" for ").append(info.getDuration()).append(", ");
                        hasGC = true;
                    }
                    if (hasGC) {
                        sb.delete(sb.length() - 2, sb.length());
                    }
                }
                catch (RuntimeException rt2) {
                    // empty catch block
                }
                rt2 = Runtime.getRuntime();
                long free = ((Runtime)rt2).freeMemory();
                long max = ((Runtime)rt2).maxMemory();
                long total = ((Runtime)rt2).totalMemory();
                sb.append(". Memory: used ").append((total - free) / 1000000L).append(" MB, available ").append((max - total + free) / 1000000L).append(" MB.");
                this.status = sb.toString();
                this.log.warning(this.status);
                this.prevWarnTime = time = System.currentTimeMillis();
            }
        } else {
            this.status = STATUS_OK;
        }
        this.prevDelay = delay;
        this.prevTime = time;
    }
}

