/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.util.VersionComparator;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.CCSVersions;
import org.lsst.ccs.bus.data.DistributionInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class AgentVersionsService
implements AgentService,
ServiceLifecycle,
HasLifecycle,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(AgentVersionsService.class.getName());
    private Map<String, DistributionInfo> allDistributionInfo = new HashMap<String, DistributionInfo>();
    public static final String AGENT = "agent";
    public static final String TOOLKIT = "toolkit";
    public static final String DISTRIBUTION = "distribution";
    private static final String VERSION = "version.";
    public static final String AGENT_VERSION = "version.agent";
    public static final String TOOLKIT_VERSION = "version.toolkit";
    public static final String DISTRIBUTION_VERSION = "version.distribution";
    private final CCSVersions ccsVersions = new CCSVersions();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private List<Object> siblings = new ArrayList<Object>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private final VersionCommands commands = new VersionCommands();
    private static final String VERSION_CONSTRAINT_PREFIX = "org.lsst.ccs.versions";

    @Override
    public String getAgentServiceName() {
        return "agentVersionsService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void preBuild() {
        Class<Agent> toolkitTopLevelClass = Agent.class;
        Class<?> topLevelClass = this.agent.getClass();
        Class<?> agentTopLevelClass = null;
        if (topLevelClass != Subsystem.class && topLevelClass != Agent.class) {
            agentTopLevelClass = topLevelClass;
        } else {
            for (Object sibling : this.siblings) {
                if (sibling instanceof AgentService) continue;
                agentTopLevelClass = sibling.getClass();
                break;
            }
        }
        if (agentTopLevelClass == null) {
            agentTopLevelClass = topLevelClass;
        }
        Properties agentVersionProps = BootstrapResourceUtils.getManifestVersionsForClass(agentTopLevelClass);
        Properties toolkitVersionProps = BootstrapResourceUtils.getManifestVersionsForClass(toolkitTopLevelClass);
        Properties distributionVersionProps = BootstrapResourceUtils.getManifestVersionsForDistribution();
        LOG.log(Level.INFO, "Toolkit Versions {0}", toolkitVersionProps);
        LOG.log(Level.INFO, "Agent Versions {0}", agentVersionProps);
        LOG.log(Level.INFO, "Distribution Versions {0}", distributionVersionProps);
        String agentVersion = agentVersionProps.getProperty("org.lsst.ccs.project.version", "notSet");
        String toolkitVersion = toolkitVersionProps.getProperty("org.lsst.ccs.project.version", "notSet");
        String distributionVersion = distributionVersionProps.getProperty("org.lsst.ccs.project.version", "notSet");
        this.agentPropertiesService.setAgentProperty(AGENT_VERSION, agentVersion);
        this.agentPropertiesService.setAgentProperty(TOOLKIT_VERSION, toolkitVersion);
        this.agentPropertiesService.setAgentProperty(DISTRIBUTION_VERSION, distributionVersion);
        this.allDistributionInfo.put(AGENT, new DistributionInfo(agentVersion));
        this.allDistributionInfo.put(TOOLKIT, new DistributionInfo(toolkitVersion));
        this.allDistributionInfo.put(DISTRIBUTION, new DistributionInfo(distributionVersion));
        Properties buildProperties = BootstrapResourceUtils.getBootstrapProperties((String)"versionConstraints");
        for (String versionKey : this.allDistributionInfo.keySet()) {
            String version = this.allDistributionInfo.get(versionKey).getVersion();
            if (System.getProperty("org.lsst.ccs.testcontext", "").equals("true")) continue;
            try {
                VersionConstraint vc = new VersionConstraint(this.extractVersionConstraintPropertiesFor(versionKey, buildProperties));
                String vcStr = vc.toString();
                if (vcStr.isEmpty()) continue;
                LOG.log(Level.INFO, "{0} version is validated according to: \n{1}", new Object[]{versionKey, vcStr});
                vc.validateVersion(version);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to validate " + versionKey + " version " + version + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void preInit() {
        this.agentCommandDictionaryService.addCommandSetToObject(this.commands, this.agent);
    }

    @Override
    public void afterInit() {
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    @Override
    public void preShutdown() {
        this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void connecting(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            this.ccsVersions.add(ai, new DistributionInfo(ai.getAgentProperty(AGENT_VERSION)));
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            this.ccsVersions.remove(ai);
        }
    }

    protected Properties extractVersionConstraintPropertiesFor(String key, Properties props) {
        Properties p = new Properties();
        p.put("max", props.getProperty(this.getPropertyKey(key, "max"), ""));
        p.put("min", props.getProperty(this.getPropertyKey(key, "min"), ""));
        p.put("allowSnapshots", props.getProperty(this.getPropertyKey(key, "allowSnapshots"), "true"));
        p.put("exclude", props.getProperty(this.getPropertyKey(key, "exclude"), "[]"));
        return p;
    }

    private String getPropertyKey(String key, String propSuffix) {
        return "org.lsst.ccs.versions." + key + "." + propSuffix;
    }

    public Map<String, DistributionInfo> getAllDistributionInfo() {
        return this.allDistributionInfo;
    }

    public class VersionCommands {
        @Command(description="Get the all the Agent's DistributionInfo.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public Map<String, DistributionInfo> getAllDistributionInfo() {
            return AgentVersionsService.this.getAllDistributionInfo();
        }

        @Command(description="Get the all the Agent's DistributionInfo names.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public Set<String> getAvailableDistributionInfoNames() {
            return AgentVersionsService.this.getAllDistributionInfo().keySet();
        }

        @Command(description="Get an Agent's DistributionInfo by name.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public DistributionInfo getDistributionInfoByName(String name) {
            return AgentVersionsService.this.getAllDistributionInfo().get(name);
        }

        @Command(description="Get the CCS Versions for the current CCS Environment", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public CCSVersions getCCSVersions() {
            CCSVersions versions = new CCSVersions(AgentVersionsService.this.ccsVersions);
            return versions;
        }

        @Command(description="Get the Agent's DistributionInfo object.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public DistributionInfo getDistributionInfo() {
            return AgentVersionsService.this.getAllDistributionInfo().get(AgentVersionsService.AGENT);
        }
    }

    public static class VersionConstraint {
        private String maxVersion;
        private String minVersion;
        private List<String> excludeVersions;
        private boolean allowSnapshots;

        VersionConstraint(Properties props) {
            this.maxVersion = props.getProperty("max", "");
            this.minVersion = props.getProperty("min", "");
            this.allowSnapshots = props.getProperty("allowSnapshots", "true").toLowerCase().equals("true");
            this.excludeVersions = (List)InputConversionEngine.convertArgToType((String)props.getProperty("exclude", "[]"), List.class);
        }

        public void validateVersion(String version) throws IllegalArgumentException {
            VersionComparator.Version v = VersionComparator.getVersion((String)version);
            if (!this.allowSnapshots && "SNAPSHOT".equals(v.qualifier())) {
                throw new RuntimeException("SNAPSHOTs are not allowed.");
            }
            if (!this.minVersion.isEmpty() && VersionComparator.compareVersion((String)version, (String)this.minVersion) < 0) {
                throw new RuntimeException("Illegal version (" + version + "); it cannot be less than " + this.minVersion);
            }
            if (!this.maxVersion.isEmpty() && VersionComparator.compareVersion((String)version, (String)this.maxVersion) > 0) {
                throw new RuntimeException("Illegal version (" + version + "); it cannot be greater than " + this.maxVersion);
            }
            for (String exclude : this.excludeVersions) {
                if (VersionComparator.compareVersion((String)version, (String)exclude) != 0) continue;
                throw new RuntimeException("Illegal version (" + version + "); it has been explicitely excluded: " + this.excludeVersions);
            }
        }

        public String toString() {
            Object result = "";
            if (!this.allowSnapshots) {
                result = (String)result + "SNAPSHOTS are not allowed\n";
            }
            if (!this.minVersion.isEmpty()) {
                result = (String)result + "min version is " + this.minVersion + "\n";
            }
            if (!this.maxVersion.isEmpty()) {
                result = (String)result + "max version is " + this.maxVersion + "\n";
            }
            if (!this.excludeVersions.isEmpty()) {
                result = (String)result + "excluded versions: " + this.excludeVersions.toString() + "\n";
            }
            return result;
        }
    }
}

