/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.pattern.FileNamePatternUtils;

public class ImageHandlingConfig
implements ConfigurationBulkChangeHandler {
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String FITSRootDirectory = System.getProperty("java.io.tmpdir");
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String FITSDirectoryPattern = "${ImageDate}/${ImageName}";
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile String FITSFilePattern = "${ImageName}_${RaftBay}_${CCDSlot}.fits";
    @ConfigurationParameter(category="FitsHandling", units="unitless")
    private volatile boolean FITSAutoSave = true;
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile String daqPartition = "dev";
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile String daqFolder = "raw";
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile String locations = "R22/Reb0,R22/Reb1,R22/Reb2";
    @ConfigurationParameter(category="DAQ", units="unitless")
    private volatile int daqThreads = 4;

    public void validateBulkChange(Map<String, Object> parametersView) {
        String dir = parametersView.get("FITSRootDirectory").toString();
        File dirFile = new File(dir);
        dirFile.mkdirs();
        if (!dirFile.isDirectory()) {
            throw new IllegalArgumentException("FITSRootDirectory: Not a directory");
        }
        if (!dirFile.canWrite()) {
            throw new IllegalArgumentException("FITSRootDirectory: Not writable");
        }
        LocationSet.of((String[])new String[]{parametersView.get("locations").toString()});
    }

    public String getFITSRootDirectory() {
        return this.FITSRootDirectory;
    }

    public String getFITSDirectoryPattern() {
        return this.FITSDirectoryPattern;
    }

    public String getFITSFilePattern() {
        return this.FITSFilePattern;
    }

    public boolean isFITSAutoSave() {
        return this.FITSAutoSave;
    }

    public String getDaqPartition() {
        return this.daqPartition;
    }

    LocationSet getLocationsToProcess() {
        return LocationSet.of((String[])new String[]{this.locations});
    }

    public String getDaqFolder() {
        return this.daqFolder;
    }

    public int getDaqThreads() {
        return this.daqThreads;
    }

    File getFitsFile(Map<String, Object> data) {
        Map<String, String> props = data.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
        File root = new File(this.FITSRootDirectory);
        String fileDir = FileNamePatternUtils.resolveFileName((String)this.FITSDirectoryPattern, props);
        File dir = new File(root, fileDir);
        String fileName = FileNamePatternUtils.resolveFileName((String)this.FITSFilePattern, props);
        File result = new File(dir, fileName);
        result.getParentFile().mkdirs();
        return result;
    }
}

