/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.imagehandling.ImageEventSender;
import org.lsst.ccs.subsystem.imagehandling.ImageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.ReadThread;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageReceivedEvent;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageHandlingClient
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageHandlingClient.class.getName());
    private ExecutorService executor;
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageHandlingConfig imageHandlingConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final List<RebNode> rebs = new ArrayList<RebNode>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;

    public void build() {
    }

    public void start() {
        LOG.log(Level.FINE, "Starting ImageHandling client {0})", this.path);
    }

    public void postStart() {
        try {
            Semaphore semaphore = new Semaphore(this.imageHandlingConfig.getDaqThreads());
            int nLocations = this.imageHandlingConfig.getLocationsToProcess().size();
            ConcurrentLinkedDeque<Store> stores = new ConcurrentLinkedDeque<Store>();
            for (int i = 0; i < nLocations + 2; ++i) {
                stores.add(new Store(this.imageHandlingConfig.getDaqPartition()));
            }
            ThreadFactory readThreadFactory = r -> new ReadThread(r, stores, semaphore);
            this.executor = new ThreadPoolExecutor(nLocations + 2, nLocations + 2, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), readThreadFactory);
            Store store = new Store(this.imageHandlingConfig.getDaqPartition());
            store.addImageListener(new ImageListener(){

                public void imageCreated(Image image) {
                }

                public void imageComplete(Image image) {
                    KeyValueData kvd = new KeyValueData("imageReceivedEvent", (Serializable)new ImageReceivedEvent(image.getMetaData()));
                    ImageHandlingClient.this.agent.publishSubsystemDataOnStatusBus(kvd);
                    String daqFolder = ImageHandlingClient.this.imageHandlingConfig.getDaqFolder();
                    if (daqFolder != null && !"".equals(daqFolder) && !ImageHandlingClient.this.imageHandlingConfig.getDaqFolder().equals(image.getMetaData().getCreationFolderName())) {
                        return;
                    }
                    LocationSet locationsWritten = new LocationSet(image.getMetaData().getLocations());
                    locationsWritten.retainAll((Collection)ImageHandlingClient.this.imageHandlingConfig.getLocationsToProcess());
                    Future<FileList> future = ImageHandlingClient.this.executor.submit(new ImageHandler(image, ImageHandlingClient.this.executor, ImageHandlingClient.this.imageHandlingConfig, ImageHandlingClient.this.rebs));
                    ImageHandlingClient.this.executor.submit(new ImageEventSender(future, ImageHandlingClient.this.agent, locationsWritten, image.getMetaData().getName()));
                }
            });
        }
        catch (DAQException x) {
            throw new RuntimeException("Failed to connect to DAQ", x);
        }
    }

    ExecutorService getExecutorService() {
        return this.executor;
    }

    FileList fetchImage(String imageName) throws DAQException, InterruptedException, ExecutionException {
        Store store = new Store(this.imageHandlingConfig.getDaqPartition());
        String daqFolder = this.imageHandlingConfig.getDaqFolder();
        Folder imageFolder = store.getCatalog().find(daqFolder);
        if (imageFolder == null) {
            throw new RuntimeException("Folder " + daqFolder + " not found");
        }
        Image image = imageFolder.find(imageName);
        if (image == null) {
            throw new RuntimeException("Image " + imageName + " not found");
        }
        LocationSet locationsWritten = new LocationSet(image.getMetaData().getLocations());
        locationsWritten.retainAll((Collection)this.imageHandlingConfig.getLocationsToProcess());
        Future<FileList> future = this.executor.submit(new ImageHandler(image, this.executor, this.imageHandlingConfig, this.rebs));
        return future.get();
    }
}

