package org.lsst.ccs.subsystem.imagehandling;

import java.util.Deque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.daq.ims.Store;

/**
 * A thread to be used for reading data from the DAQ. Each thread has its own
 * store object created when the thread is created. All thread share a semaphore
 * object used to limit how many threads can simultaneously read from the DAQ.
 * @author tonyj
 */
class ReadThread extends Thread {

    private final Store store;
    private final Semaphore semaphore;
    private static final AtomicInteger n = new AtomicInteger(0);
    private final Deque<Store> stores;

    ReadThread(Runnable r, Deque<Store> stores, Semaphore semaphore) {
        super(r);
        this.setName("DAQ_read_thread_" + n.getAndAdd(1));
        this.setDaemon(true);
        this.stores = stores;
        this.store = stores.pop();
        this.semaphore = semaphore;
    }

    @Override
    @SuppressWarnings("CallToThreadRun")
    public void run() {
        try {
            super.run();
        } finally {
            stores.addLast(store);
        }
    }

    public Store getStore() {
        return store;
    }

    public Semaphore getSemaphore() {
        return semaphore;
    }
}
