/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.GuiderCCD;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.WFCCDType;
import org.lsst.ccs.utilities.ccd.WavefrontCCD;

public class CornerRaft
extends Raft {
    private final CornerRaftPosition position;

    public CornerRaft(CCDType type, CornerRaftPosition position) {
        this(RaftGeometryConstants.createRaftGeometryConstants(type), type, position);
    }

    CornerRaft(RaftGeometryConstants raftConstants, CCDType type, CornerRaftPosition position) {
        super(raftConstants, type);
        this.position = position;
    }

    @Override
    protected void populateRebList() {
        this.rebList.add(new Reb(Reb.RebType.WAVEFRONT, "RebW", this));
        this.rebList.add(new Reb(Reb.RebType.GUIDER, "RebG", this));
    }

    @Override
    protected void addCCDtoReb(CCD child, int p, int s) {
        if (child instanceof WavefrontCCD) {
            ((Reb)this.rebList.get(0)).addCCD(child);
        } else if (child instanceof GuiderCCD) {
            ((Reb)this.rebList.get(1)).addCCD(child);
        } else {
            throw new RuntimeException("Only Guider or Wavefront sensor can be added to a CornerRaft. Type " + child.getType() + " not allowed.");
        }
    }

    public CornerRaftPosition getCornerRaftPosition() {
        return this.position;
    }

    public static CornerRaft createCornerRaft(CornerRaftPosition position) {
        ITLCCDType guiderType = new ITLCCDType();
        CornerRaft raft = new CornerRaft(guiderType, position);
        GuiderCCD guider0 = GuiderCCD.createGuiderCCD(guiderType, GuiderCCD.GuiderType.GUIDER0);
        GuiderCCD guider1 = GuiderCCD.createGuiderCCD(guiderType, GuiderCCD.GuiderType.GUIDER1);
        WFCCDType wftype = new WFCCDType();
        WavefrontCCD wflow = WavefrontCCD.createWavefrontCCD(wftype, WavefrontCCD.WavefrontType.WF0);
        WavefrontCCD wfhigh = WavefrontCCD.createWavefrontCCD(wftype, WavefrontCCD.WavefrontType.WF1);
        raft.addCCDtoReb(wflow, 0, 0);
        raft.addCCDtoReb(wfhigh, 0, 1);
        wflow.setParallelPosition(0);
        wflow.setSerialPosition(0);
        wfhigh.setParallelPosition(0);
        wfhigh.setSerialPosition(1);
        switch (position) {
            case CR44: {
                int x = CornerRaft.getXcoord(wflow, raft, 0, 0);
                int y = CornerRaft.getYcoord(wflow, raft, 0, 0);
                raft.addGeometry(wflow, x + wflow.getWidth(), y);
                raft.addGeometry(wfhigh, x, y);
                raft.addChildGeometry(guider0, 1, 0);
                raft.addChildGeometry(guider1, 0, 1);
                break;
            }
            case CR04: {
                int x = CornerRaft.getXcoord(wflow, raft, 2, 0);
                int y = CornerRaft.getYcoord(wflow, raft, 2, 0);
                raft.addGeometry(wflow, x + wflow.getWidth(), y);
                raft.addGeometry(wfhigh, x, y);
                raft.addChildGeometry(guider0, 1, 0);
                raft.addChildGeometry(guider1, 0, 1);
                break;
            }
            case CR00: {
                int x = CornerRaft.getXcoord(wflow, raft, 2, 2);
                int y = CornerRaft.getYcoord(wflow, raft, 2, 2);
                raft.addGeometry(wflow, x + wflow.getWidth(), y);
                raft.addGeometry(wfhigh, x, y);
                raft.addChildGeometry(guider0, 1, 0);
                raft.addChildGeometry(guider1, 0, 1);
                break;
            }
            case CR40: {
                int x = CornerRaft.getXcoord(wflow, raft, 0, 2);
                int y = CornerRaft.getYcoord(wflow, raft, 0, 2);
                raft.addGeometry(wflow, x + wflow.getWidth(), y);
                raft.addGeometry(wfhigh, x, y);
                raft.addChildGeometry(guider0, 1, 0);
                raft.addChildGeometry(guider1, 0, 1);
            }
        }
        return raft;
    }

    private static int getXcoord(WavefrontCCD child, CornerRaft raft, int p, int s) {
        return (2 - p) * (2 * child.getWidth()) + (2 - p) * raft.getRaftGeometryConstants().getGap_inx() + (int)raft.getRaftGeometryConstants().getGap_outx();
    }

    private static int getYcoord(WavefrontCCD child, CornerRaft raft, int p, int s) {
        return (raft.getSerialChildrenCount() - 1 - s) * (child.getHeight() + raft.getRaftGeometryConstants().getGap_iny()) + (int)raft.getRaftGeometryConstants().getGap_outy();
    }

    public static int getXoff1() {
        return 249;
    }

    public static int getXoff2() {
        return 138;
    }

    public static int getYoff1() {
        return 151;
    }

    public static int getYoff2() {
        return 236;
    }

    public static int getOverhang() {
        return 100;
    }

    public static int getCrdim() {
        return 11630;
    }

    public static enum CornerRaftPosition {
        CR04(0, 4),
        CR00(0, 0),
        CR40(4, 0),
        CR44(4, 4);

        private final int parallelPosition;
        private final int serialPosition;

        private CornerRaftPosition(int parallelPosition, int serialPosition) {
            this.parallelPosition = parallelPosition;
            this.serialPosition = serialPosition;
        }

        public int getParallelPosition() {
            return this.parallelPosition;
        }

        public int getSerialPosition() {
            return this.serialPosition;
        }
    }
}

