package org.lsst.ccs.subsystem.imagehandling;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;

public class ImageHandlingSubsystem extends Subsystem implements HasLifecycle {
    
    public ImageHandlingSubsystem() {
        super("image-handling", AgentInfo.AgentType.SERVICE);
        getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        getAgentInfo().getAgentProperties().setProperty(AgentCategory.AGENT_CATEGORY_PROPERTY, AgentCategory.IMAGE_HANDLER.name());
    }

    @Override
    public void build() {
        ComponentLookup lookupService = getComponentLookup();
        ComponentNode thisComponent = lookupService.getComponentNodeForObject(this);

        //Add listener to focal-plane configuration changes
        ComponentNode focalPlaneConfigurationHandler = new ComponentNode("configHandler", new FocalPlaneConfigurationHandler());
        lookupService.addComponentNodeToLookup(thisComponent, focalPlaneConfigurationHandler);        
    }
    
    @Override
    public void start() {
    }
}
