/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.imagehandling.ImageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingSubsystem;

public class ImageHandlerTest {
    @Test
    public void testAlerts() throws Exception {
        ImageHandlingSubsystem a = new ImageHandlingSubsystem();
        a.startAgent();
        ((AgentStateService)a.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
        AlertService alertService = (AlertService)a.getAgentService(AlertService.class);
        ImageHandlingClient ihClient = new ImageHandlingClient();
        ihClient.registerAlerts(alertService);
        ImageHandlingConfig config = new ImageHandlingConfig();
        ImageHandler imageHandler = new ImageHandler(null, null, null, config, null, true, true, null, alertService);
        config.raiseAlertOnMissingOrBadHeaderServiceData = false;
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().isEmpty());
        imageHandler.mergeHeaderServiceData(null, null);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().isEmpty());
        config.raiseAlertOnMissingOrBadHeaderServiceData = true;
        imageHandler.mergeHeaderServiceData(null, null);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.ALARM ? 1 : 0) != 0);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((alertService.getRaisedAlertSummary().getRaisedAlert("missingHeaders") != null ? 1 : 0) != 0);
        alertService.clearAlerts(new String[]{"missingHeaders"});
        Assert.assertTrue((alertService.getRaisedAlertSummary().getAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alertService.getRaisedAlertSummary().getAllRaisedAlertHistories().isEmpty());
        a.shutdownAgent();
    }
}

