/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageEventSender
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ImageEventSender.class.getName());
    private final FileList fileList;
    private final Agent agent;
    private final String imageName;
    private final LocationSet locations;
    private final Exception ex;

    public ImageEventSender(FileList fileList, Exception ex, Agent agent, LocationSet locations, String imageName) {
        this.fileList = fileList;
        this.ex = ex;
        this.agent = agent;
        this.imageName = imageName;
        this.locations = locations;
    }

    @Override
    public void run() {
        FitsFilesWrittenEvent event;
        if (this.fileList == null) {
            LOG.log(Level.SEVERE, "Unexpected exception waiting for file list", this.ex);
            event = new FitsFilesWrittenEvent(this.imageName, this.ex);
        } else {
            LOG.log(Level.INFO, "File list received {0}", this.fileList);
            event = new FitsFilesWrittenEvent(this.imageName, this.fileList, this.locations);
        }
        KeyValueData kvd = new KeyValueData("fitsFilesWrittenEvent", (Serializable)event);
        this.agent.publishSubsystemDataOnStatusBus(kvd);
    }
}

