/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;
import org.lsst.ccs.subsystem.imagehandling.data.HeaderServiceEnabled;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderKeywords;

class BusMessageHandler
implements HasLifecycle {
    private volatile String[] metaDataRegisters;
    private FocalPlaneConfigurationAndDataListener configListener;
    private OCSBridgeDataListener ocsBridgeDataListener;
    private static final Logger LOG = Logger.getLogger(BusMessageHandler.class.getName());
    private final Predicate<BusMessage<? extends Serializable, ?>> focalPlanePredicate = bm -> BusMessageHandler.isFocalPlaneAgent(bm.getOriginAgentInfo());
    private final Predicate<BusMessage<? extends Serializable, ?>> ocsBridgePredicate = bm -> BusMessageHandler.isOCSBridgeAgent(bm.getOriginAgentInfo());
    private final Predicate<BusMessage<? extends Serializable, ?>> headerKeywordsPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "ImageHeaderKeywords".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> headerDataPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "imageHeaderData".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> headerServiceEnabledPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "headerServiceEnabled".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> configurationDataPredicate = BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class);
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageHandlingClient imageHandlingClient;

    BusMessageHandler() {
    }

    public void postStart() {
        this.configListener = new FocalPlaneConfigurationAndDataListener();
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.configListener, this.focalPlanePredicate.and(this.configurationDataPredicate.or(this.headerKeywordsPredicate)));
        this.ocsBridgeDataListener = new OCSBridgeDataListener();
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.ocsBridgeDataListener, this.ocsBridgePredicate.and(this.headerDataPredicate.or(this.headerServiceEnabledPredicate)));
    }

    public void shutdown() {
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.configListener);
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.ocsBridgeDataListener);
    }

    public String[] getMetaDataRegisters() {
        return this.metaDataRegisters;
    }

    private static boolean isFocalPlaneAgent(AgentInfo agentInfo) {
        return AgentCategory.FOCAL_PLANE.name().equals(agentInfo.getAgentProperty("agentCategory"));
    }

    private static boolean isOCSBridgeAgent(AgentInfo agentInfo) {
        return AgentInfo.AgentType.OCS_BRIDGE.equals((Object)agentInfo.getType());
    }

    static /* synthetic */ String[] access$202(BusMessageHandler x0, String[] x1) {
        x0.metaDataRegisters = x1;
        return x1;
    }

    private class FocalPlaneConfigurationAndDataListener
    implements StatusMessageListener {
        private FocalPlaneConfigurationAndDataListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusConfigurationInfo) {
                ConfigurationInfo ci = ((StatusConfigurationInfo)msg).getConfigurationInfo();
                for (ConfigurationParameterInfo cpi : ci.getAllParameterInfo()) {
                    if (!cpi.getComponentName().equals("focalPlaneConfig") || !cpi.getParameterName().equals("metaDataRegisters")) continue;
                    BusMessageHandler.access$202(BusMessageHandler.this, (String[])cpi.getCurrentValueObject());
                    LOG.log(Level.FINEST, "Updating metaDataRegister to {0}", new Object[]{Arrays.asList(BusMessageHandler.this.metaDataRegisters)});
                }
            }
            if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                ImageHeaderKeywords keywords = (ImageHeaderKeywords)((KeyValueData)ssd.getObject()).getValue();
                Map headerMap = keywords.getKeywords();
                LOG.log(Level.INFO, () -> String.format("Received image header keywords %s", keywords));
                if (headerMap.containsKey("darkTime")) {
                    BusMessageHandler.this.imageHandlingClient.darkTimeArrived();
                } else if (headerMap.containsKey("RunNumber")) {
                    Object runNumber = headerMap.get("RunNumber");
                    BusMessageHandler.this.imageHandlingClient.runNumberArrived(runNumber == null ? null : runNumber.toString());
                }
                BusMessageHandler.this.imageHandlingClient.addMetaData(keywords.getImageName(), keywords.getKeywords());
            }
        }
    }

    private class OCSBridgeDataListener
    implements StatusMessageListener {
        private OCSBridgeDataListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                if (ssd.getDataKey().equals("imageHeaderData")) {
                    ImageHeaderData data = (ImageHeaderData)((KeyValueData)ssd.getObject()).getValue();
                    StringBuilder imageName = new StringBuilder("aa_b_cccccccc_dddddd");
                    for (ImageHeaderData.Header header : data.getHeaders()) {
                        if (header.getKeyword() == null) continue;
                        String value = header.getValue();
                        switch (header.getKeyword()) {
                            case "CAMCODE": {
                                imageName.replace(0, 2, value);
                                break;
                            }
                            case "CONTRLLR": {
                                imageName.replace(3, 4, value);
                                break;
                            }
                            case "DAYOBS": {
                                imageName.replace(5, 13, value);
                                break;
                            }
                            case "SEQNUM": {
                                imageName.replace(14, 20, String.format("%06d", Integer.parseInt(value)));
                            }
                        }
                    }
                    LOG.log(Level.INFO, "Received image headers for {0}: {1}", new Object[]{imageName, data.getHeaders()});
                    BusMessageHandler.this.imageHandlingClient.headerDataArrived(imageName.toString(), data.getHeaders());
                } else if (ssd.getDataKey().equals("headerServiceEnabled")) {
                    HeaderServiceEnabled headerServiceEnabled = (HeaderServiceEnabled)((KeyValueData)ssd.getObject()).getValue();
                    LOG.log(Level.INFO, "Received headerServiceEnabled: {0}", headerServiceEnabled.isEnabled());
                    BusMessageHandler.this.imageHandlingClient.setHeaderServiceEnabled(headerServiceEnabled.isEnabled());
                }
            }
        }
    }
}

