package org.lsst.ccs.subsystem.imagehandling;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

/**
 * Utilities for use with CompleteableFuture
 * @author tonyj
 */
public class CompletableUtils {

    /**
     * An adapter to allow a callable to be called asynchronously with a CompletableFuture returned
     * to represent the eventual result of the callable.
     * @param <T> The type of ComplteableFuture to return
     * @param executor The executor to use to execute the callable
     * @param callable The callable to call
     * @return A CompletebleFuture to be completed when execution of the callable completes.
     */
    static <T> CompletableFuture<T> asyncCallable(ExecutorService executor, Callable<T> callable) {
        CompletableFuture<T> future = new CompletableFuture<>();
        executor.execute(() -> {
            try {
                future.complete(callable.call());
            } catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }
}
