import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.daq.utilities.FitsService
import org.lsst.ccs.subsystem.imagehandling.*;
import org.lsst.ccs.utilities.ccd.*;
import java.util.List;
import org.lsst.ccs.services.AgentStatusAggregatorService;


CCSBuilder builder = ["image-handling"]

Properties buildProperties = buildProperties();
List rebs = buildPropertyValue("org.lsst.ccs.subsystem.imagehandling.rebs", List.class, null);
FocalPlane focalPlane = FocalPlane.createFocalPlane(buildProperties.getProperty("org.lsst.ccs.subsystem.imagehanding.rafts",""));

builder.
    "main" (ImageHandlingSubsystem) {
    
      statusAggregator (AgentStatusAggregatorService)
    
      "imageHandler" (ImageHandlingClient) {
          "ImageHandlingConfig" (ImageHandlingConfig);
      }
    
    for ( String reb : rebs ) {
        Reb r = focalPlane.getReb("$reb");
        "$reb" (RebNode, reb:r) {

            fitsService (FitsService, 
               reb:r
            )

        }
    }
}
