/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.AsciiFuncs;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.CompletableUtils;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.SourceHandler;
import org.lsst.ccs.subsystem.imagehandling.config.WaitForHeaderService;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

class ImageHandler
implements Callable<FileList> {
    private static final Logger LOG = Logger.getLogger(ImageHandler.class.getName());
    private final Image image;
    private final ImageHandlingConfig config;
    private final ExecutorService executor;
    private final List<RebNode> rebs;
    private final boolean isStreaming;
    private final CountDownLatch darkTime = new CountDownLatch(1);
    private final CommandExecutor commandExecutor;
    private final CompletableFuture<List<ImageHeaderData.Header>> futureHeaderData;
    private final boolean isHeaderServiceEnabled;
    private final Map<String, Serializable> imageMetaData;

    ImageHandler(Map<String, Serializable> imageMetaData, Image image, ExecutorService executor, ImageHandlingConfig config, List<RebNode> rebs, boolean isStreaming, boolean isHeaderServiceEnabled, CommandExecutor commandExecutor) {
        this.imageMetaData = imageMetaData;
        this.image = image;
        this.config = config;
        this.executor = executor;
        this.rebs = rebs;
        this.isStreaming = isStreaming;
        this.isHeaderServiceEnabled = isHeaderServiceEnabled;
        this.commandExecutor = commandExecutor;
        this.futureHeaderData = new CompletableFuture<Object>().completeOnTimeout(null, Integer.getInteger("org.lsst.ccs.subsystem.imagehandling.headerTimeoutSeconds", 15).intValue(), TimeUnit.SECONDS);
    }

    @Override
    public FileList call() throws IOException, DAQException, InterruptedException, ExecutionException {
        List sources = this.image.listSources();
        LocationSet locationsToProcess = this.config.getLocationsToProcess();
        ArrayList lffl = new ArrayList();
        sources.stream().filter(arg_0 -> ImageHandler.lambda$call$0((Set)locationsToProcess, arg_0)).forEach(source -> {
            Location location = source.getLocation();
            for (RebNode r : this.rebs) {
                if (!r.isEnabled() || !r.getLocation().equals((Object)location)) continue;
                SourceHandler sourceHandler = new SourceHandler(this.imageMetaData, this.darkTime, this.image.getMetaData().getName(), (Source)source, this.config, r, this.isStreaming);
                CompletionStage<Object> futureFilelist = CompletableUtils.asyncCallable(this.executor, sourceHandler);
                if (this.config.getWaitForHeaderService() == WaitForHeaderService.ALWAYS || this.config.getWaitForHeaderService() == WaitForHeaderService.AUTO && this.isHeaderServiceEnabled) {
                    futureFilelist = ((CompletableFuture)futureFilelist).thenCombine(this.futureHeaderData, (fl, headerData) -> {
                        if (headerData == null) {
                            LOG.log(Level.WARNING, "Header service data did not arrive in a timely manner");
                        } else {
                            try {
                                this.fixupFitsFiles((FileList)fl, (List<ImageHeaderData.Header>)headerData);
                            }
                            catch (IOException | FitsException x) {
                                LOG.log(Level.WARNING, "Error while fixing FITS headers", x);
                            }
                        }
                        return fl;
                    });
                }
                lffl.add(futureFilelist);
                if (this.config.getCommands().isEmpty()) continue;
                ((CompletableFuture)futureFilelist).thenAccept(fl -> {
                    HashMap<String, String> env = new HashMap<String, String>();
                    env.put("BOARD", location.getBoardName());
                    env.put("RAFT", location.getRaftName());
                    String imageName = this.image.getMetaData().getName();
                    env.put("IMAGENAME", imageName);
                    try {
                        ImageName in = new ImageName(imageName);
                        env.put("SEQNO", in.getNumberString());
                        env.put("DATE", in.getDateString());
                        env.put("CONTROLLER", in.getController().getCode());
                        env.put("SOURCE", in.getSource().getCode());
                    }
                    catch (IllegalArgumentException x) {
                        env.put("SEQNO", "UNKNOWN");
                        env.put("DATE", "UNKNOWN");
                        env.put("CONTROLLER", "UNKNOWN");
                        env.put("SOURCE", "UNKNOWN");
                    }
                    this.commandExecutor.execute((FileList)fl, (Map<String, String>)env);
                });
            }
        });
        FileList result = new FileList();
        for (Future ffl : lffl) {
            FileList fl = (FileList)ffl.get();
            result.addAll(fl);
        }
        return result;
    }

    void darkTimeArrived() {
        this.darkTime.countDown();
    }

    void headerDataArrived(List<ImageHeaderData.Header> headers) {
        this.futureHeaderData.complete(headers);
    }

    private void fixupFitsFiles(FileList fileList, List<ImageHeaderData.Header> headerData) throws FitsException, IOException {
        for (File file : fileList) {
            Fits fits = new Fits(file);
            BasicHDU hdu = fits.getHDU(0);
            Header header = hdu.getHeader();
            long deltaCheckSum = 0L;
            for (ImageHeaderData.Header headerServiceHeader : headerData) {
                String keyword = headerServiceHeader.getKeyword();
                if (keyword == null || "COMMENT".equals(keyword)) continue;
                if (keyword.startsWith("HIERARCH")) {
                    keyword = keyword.replace(" ", ".");
                }
                HeaderCard card = header.findCard(keyword);
                String newValue = headerServiceHeader.getValue();
                if (card != null) {
                    String oldValue = card.getValue();
                    if ((oldValue == null || oldValue.isEmpty()) && newValue != null && !newValue.isEmpty()) {
                        long oldCheckSum = FitsCheckSum.checksum((byte[])AsciiFuncs.getBytes((String)card.toString()));
                        if (!this.isString(newValue)) {
                            card.setValue(headerServiceHeader.getValue());
                        } else {
                            card = new HeaderCard(card.getKey(), newValue, card.getComment());
                            header.updateLine(card.getKey(), card);
                        }
                        long newCheckSum = FitsCheckSum.checksum((byte[])AsciiFuncs.getBytes((String)card.toString()));
                        deltaCheckSum += newCheckSum - oldCheckSum;
                        continue;
                    }
                    if (Objects.equals(oldValue, newValue)) continue;
                    LOG.log(Level.WARNING, "For card {0} header service={1} but CCS={2}", new Object[]{card.getKey(), newValue, oldValue});
                    continue;
                }
                LOG.log(Level.WARNING, "For card {0} header service={1} but CCS was not defined", new Object[]{keyword, newValue});
            }
            FitsCheckSum.updateCheckSum((Header)header, (long)deltaCheckSum);
            header.rewrite();
        }
    }

    private boolean isString(String string) {
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return false;
        }
        catch (NumberFormatException x) {
            return true;
        }
    }

    private static /* synthetic */ boolean lambda$call$0(Set locationsToProcess, Source source) {
        return locationsToProcess.contains(source.getLocation());
    }
}

