/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import nom.tam.fits.FitsException;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.states.ImageHandlingState;

class SourceHandler
implements Callable<FileList> {
    private static final String TMP_POSTFIX = ".$tmp$";
    private final Source source;
    private static final int BUFFER_SIZE = 0x100000;
    private final ImageHandlingConfig config;
    private final RebNode rebNode;

    SourceHandler(Source source, ImageHandlingConfig config, RebNode rebNode) {
        this.source = source;
        this.config = config;
        this.rebNode = rebNode;
    }

    @Override
    public FileList call() throws IOException, DAQException, FitsException {
        this.rebNode.updateState(ImageHandlingState.READING);
        try {
            FileList result = new FileList();
            FitsIntWriter.FileNamer namer = props -> {
                File file = this.config.getFitsFile(props);
                props.put("OriginalFileName", file.getName());
                File tmpFile = new File(file.getParent(), file.getName() + TMP_POSTFIX);
                return tmpFile;
            };
            FitsIntWriter.PerCCDMetaDataProvider metaDataProvider = ccd -> Collections.singletonList(this.rebNode.getFitsService().getFitsHeaderMetadataProvider(ccd.getUniqueId()));
            List filesToBeWritten = null;
            IOException io = null;
            try (FitsIntWriter decompress = new FitsIntWriter(this.source, this.rebNode.getReb(), this.rebNode.getFitsService().getHeaderSpecificationMap(), namer, metaDataProvider);
                 ByteChannel readChannel = this.source.openChannel(Source.ChannelMode.READ);){
                int l;
                filesToBeWritten = decompress.getFiles();
                ByteBuffer bb = ByteBuffer.allocateDirect(0x100000);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                while ((l = readChannel.read(bb)) >= 0) {
                    bb.flip();
                    decompress.write(bb.asIntBuffer());
                    bb.clear();
                }
            }
            catch (IOException x) {
                io = x;
                throw io;
            }
            finally {
                if (filesToBeWritten != null) {
                    if (io != null) {
                        for (File file : filesToBeWritten) {
                            file.delete();
                        }
                    } else {
                        for (File file : filesToBeWritten) {
                            String oldName = file.getName();
                            if (!oldName.endsWith(TMP_POSTFIX)) continue;
                            String newName = oldName.substring(0, oldName.length() - TMP_POSTFIX.length());
                            File newFile = new File(file.getParent(), newName);
                            boolean success = file.renameTo(newFile);
                            if (!success) {
                                throw new IOException("Unable to rename " + oldName + " to " + newName);
                            }
                            result.add((Object)newFile);
                        }
                    }
                }
            }
            FileList fileList = result;
            return fileList;
        }
        catch (IOException ioe) {
            throw new IOException("Exception for " + this.rebNode.getReb().getFullName(), ioe);
        }
        finally {
            this.rebNode.updateState(ImageHandlingState.IDLE);
        }
    }
}

