package org.lsst.ccs.subsystem.imagehandling;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;

public class ImageHandlingSubsystem extends Subsystem implements HasLifecycle {

    @LookupField(strategy = LookupField.Strategy.DESCENDANTS)
    private ImageHandlingClient imageHandlingClient;

    public ImageHandlingSubsystem() {
        super("image-handling", AgentInfo.AgentType.SERVICE);
        getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        getAgentInfo().getAgentProperties().setProperty(AgentCategory.AGENT_CATEGORY_PROPERTY, AgentCategory.IMAGE_HANDLER.name());
    }

    @Override
    public void build() {
        ComponentLookup lookupService = getComponentLookup();
        ComponentNode thisComponent = lookupService.getComponentNodeForObject(this);

        //Add listener to focal-plane configuration changes
        ComponentNode focalPlaneConfigurationHandler = new ComponentNode("configHandler", new BusMessageHandler());
        lookupService.addComponentNodeToLookup(thisComponent, focalPlaneConfigurationHandler);
    }

    @Override
    public void start() {
        // Turn off annoying messages from FITS (LSSTCCSRAFTS-656)
        Logger.getLogger("nom.tam.fits.HeaderCard").setLevel(Level.WARNING);
    }

    @Command(type = Command.CommandType.ACTION, description = "Fetch a named image from the 2-day store")
    public FileList fetchImage(String imageName) {
        return helper()
                .precondition(imageHandlingClient != null, "No image handling client registered")
                .enterFaultOnException(true)
                .action(() -> {
                    return imageHandlingClient.fetchImage(imageName);
                });
    }
}
