/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.subsystem.imagehandling.ImageEventSender;
import org.lsst.ccs.subsystem.imagehandling.ImageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.ReadThread;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageReceivedEvent;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageHandlingClient
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageHandlingClient.class.getName());
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageHandlingConfig imageHandlingConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final List<RebNode> rebs = new ArrayList<RebNode>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService statusAggregator;
    private ExecutorService executor;
    private volatile ImageHandler imageHandler;
    private volatile boolean darkTimeArrived = false;
    private volatile String runNumber;
    private String previousRunNumber;

    public void build() {
    }

    public void start() {
        LOG.log(Level.FINE, "Starting ImageHandling client {0})", this.path);
    }

    public void postStart() {
        try {
            Semaphore semaphore = new Semaphore(this.imageHandlingConfig.getDaqThreads());
            int nLocations = this.imageHandlingConfig.getLocationsToProcess().size();
            int nThreads = Math.max(20, nLocations + 2);
            ConcurrentLinkedDeque<Store> stores = new ConcurrentLinkedDeque<Store>();
            for (int i = 0; i < nThreads; ++i) {
                stores.add(new Store(this.imageHandlingConfig.getDaqPartition()));
            }
            ThreadFactory readThreadFactory = r -> new ReadThread(r, stores, semaphore);
            this.executor = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), readThreadFactory);
            Store store = new Store(this.imageHandlingConfig.getDaqPartition());
            store.addImageListener(new ImageListener(){

                public void imageCreated(Image image) {
                    if (ImageHandlingClient.this.imageHandlingConfig.isUseStreaming()) {
                        if (!this.checkFolder(image)) {
                            return;
                        }
                        this.handleImage(image, true);
                    }
                }

                public void imageComplete(Image image) {
                    KeyValueData kvd = new KeyValueData("imageReceivedEvent", (Serializable)new ImageReceivedEvent(image.getMetaData()));
                    ImageHandlingClient.this.agent.publishSubsystemDataOnStatusBus(kvd);
                    if (!ImageHandlingClient.this.imageHandlingConfig.isUseStreaming()) {
                        if (!this.checkFolder(image)) {
                            return;
                        }
                        this.handleImage(image, false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void handleImage(Image image, boolean isStreaming) {
                    LocationSet locationsWritten = new LocationSet(image.getMetaData().getLocations());
                    locationsWritten.retainAll((Collection)ImageHandlingClient.this.imageHandlingConfig.getLocationsToProcess());
                    ImageHandlingClient imageHandlingClient = ImageHandlingClient.this;
                    synchronized (imageHandlingClient) {
                        if (!Objects.equals(ImageHandlingClient.this.runNumber, ImageHandlingClient.this.previousRunNumber)) {
                            LOG.log(Level.INFO, () -> String.format("Run number changed from %s to %s, clearing status aggregators", ImageHandlingClient.this.previousRunNumber, ImageHandlingClient.this.runNumber));
                            ImageHandlingClient.this.previousRunNumber = ImageHandlingClient.this.runNumber;
                            Instant cutoff = Instant.now().minus(Duration.ofMinutes(1L));
                            for (String subsystemToClear : ImageHandlingClient.this.imageHandlingConfig.getSubsystemsToClear()) {
                                long start = System.nanoTime();
                                ImageHandlingClient.this.statusAggregator.clearAgentDataOlderThan(subsystemToClear, cutoff);
                                LOG.log(Level.INFO, () -> String.format("Clearing status aggregator for %s took %,dns", subsystemToClear, System.nanoTime() - start));
                            }
                        }
                        ImageHandlingClient.this.imageHandler = new ImageHandler(image, ImageHandlingClient.this.executor, ImageHandlingClient.this.imageHandlingConfig, ImageHandlingClient.this.rebs, isStreaming);
                        if (ImageHandlingClient.this.darkTimeArrived) {
                            ImageHandlingClient.this.imageHandler.darkTimeArrived();
                        }
                    }
                    Future<FileList> future = ImageHandlingClient.this.executor.submit(ImageHandlingClient.this.imageHandler);
                    ImageHandlingClient.this.executor.submit(() -> {
                        try {
                            Object filelist = (FileList)future.get(Integer.getInteger("org.lsst.ccs.subsystem.imagehandling.FitsTimeoutSeconds", 30).intValue(), TimeUnit.SECONDS);
                            ImageEventSender sender = new ImageEventSender((FileList)filelist, null, ImageHandlingClient.this.agent, locationsWritten, image.getMetaData().getName());
                            sender.run();
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException x) {
                            ImageEventSender sender = new ImageEventSender(null, x, ImageHandlingClient.this.agent, locationsWritten, image.getMetaData().getName());
                            sender.run();
                        }
                        finally {
                            ImageHandlingClient imageHandlingClient = ImageHandlingClient.this;
                            synchronized (imageHandlingClient) {
                                ImageHandlingClient.this.darkTimeArrived = false;
                                ImageHandlingClient.this.runNumber = null;
                                ImageHandlingClient.this.imageHandler = null;
                            }
                        }
                    });
                }

                private boolean checkFolder(Image image) {
                    String daqFolder = ImageHandlingClient.this.imageHandlingConfig.getDaqFolder();
                    return daqFolder == null || "".equals(daqFolder) || ImageHandlingClient.this.imageHandlingConfig.getDaqFolder().equals(image.getMetaData().getCreationFolderName());
                }
            });
        }
        catch (DAQException x) {
            throw new RuntimeException("Failed to connect to DAQ", x);
        }
    }

    ExecutorService getExecutorService() {
        return this.executor;
    }

    FileList fetchImage(String imageName) throws DAQException, InterruptedException, ExecutionException {
        Store store = new Store(this.imageHandlingConfig.getDaqPartition());
        String daqFolder = this.imageHandlingConfig.getDaqFolder();
        Folder imageFolder = store.getCatalog().find(daqFolder);
        if (imageFolder == null) {
            throw new RuntimeException("Folder " + daqFolder + " not found");
        }
        Image image = imageFolder.find(imageName);
        if (image == null) {
            throw new RuntimeException("Image " + imageName + " not found");
        }
        LocationSet locationsWritten = new LocationSet(image.getMetaData().getLocations());
        locationsWritten.retainAll((Collection)this.imageHandlingConfig.getLocationsToProcess());
        Future<FileList> future = this.executor.submit(new ImageHandler(image, this.executor, this.imageHandlingConfig, this.rebs, false));
        return future.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void darkTimeArrived() {
        ImageHandlingClient imageHandlingClient = this;
        synchronized (imageHandlingClient) {
            if (this.imageHandler != null) {
                this.imageHandler.darkTimeArrived();
            } else {
                this.darkTimeArrived = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runNumberArrived(String runNumber) {
        ImageHandlingClient imageHandlingClient = this;
        synchronized (imageHandlingClient) {
            this.runNumber = runNumber;
        }
    }
}

