/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.imagehandling.BusMessageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;

public class ImageHandlingSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageHandlingClient imageHandlingClient;

    public ImageHandlingSubsystem() {
        super("image-handling", AgentInfo.AgentType.SERVICE);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        this.getAgentInfo().getAgentProperties().setProperty("agentCategory", AgentCategory.IMAGE_HANDLER.name());
        Logger.getLogger("nom.tam.fits.HeaderCard").setLevel(Level.WARNING);
    }

    public void build() {
        ComponentLookup lookupService = this.getComponentLookup();
        ComponentNode thisComponent = lookupService.getComponentNodeForObject((Object)this);
        ComponentNode focalPlaneConfigurationHandler = new ComponentNode("configHandler", (Object)new BusMessageHandler());
        lookupService.addComponentNodeToLookup(thisComponent, focalPlaneConfigurationHandler);
    }

    public void start() {
    }

    @Command(type=Command.CommandType.ACTION, description="Fetch a named image from the 2-day store")
    public FileList fetchImage(String imageName) {
        return (FileList)this.helper().precondition(this.imageHandlingClient != null, "No image handling client registered", new Object[0]).enterFaultOnException(true).action(() -> this.imageHandlingClient.fetchImage(imageName));
    }
}

