/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.channel.BadPixelDetector;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.ReadThread;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.states.ImageHandlingState;

class SourceHandler
implements Callable<FileList> {
    private static final Logger LOG = Logger.getLogger(SourceHandler.class.getName());
    private final Source source;
    private static final int BUFFER_SIZE = Integer.getInteger("org.lsst.ccs.subsystem.imagehandling.BufferSize", 1950720);
    private final ImageHandlingConfig config;
    private final RebNode rebNode;
    private final boolean isStreaming;
    private final CountDownLatch darkTime;
    private BadPixelDetector badPixelDetector;

    SourceHandler(CountDownLatch darkTime, Source source, ImageHandlingConfig config, RebNode rebNode, boolean isStreaming) {
        this.darkTime = darkTime;
        this.source = source;
        this.config = config;
        this.rebNode = rebNode;
        this.isStreaming = isStreaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileList call() throws IOException {
        this.rebNode.updateState(ImageHandlingState.READING);
        HashMap tmpMap = new HashMap();
        try {
            FileList result = new FileList();
            FitsIntWriter.FileNamer namer = props -> {
                File file = this.config.getFitsFile(props);
                props.put("OriginalFileName", file.getName());
                if (this.config.isUseTempFile()) {
                    File tmpFile = this.config.getTempFitsFile(props);
                    tmpMap.put(tmpFile, file);
                    return tmpFile;
                }
                return file;
            };
            FitsIntWriter.PerCCDMetaDataProvider metaDataProvider = ccd -> Collections.singletonList(this.rebNode.getFitsService().getFitsHeaderMetadataProvider(ccd.getUniqueId()));
            IOException io = null;
            ReadThread readThread = (ReadThread)Thread.currentThread();
            FitsIntWriter decompress = this.config.isCheckForBadPixels() ? (this.isStreaming ? new FitsIntWriter(this.source.getImage(), this.rebNode.getReb(), namer){

                protected WritableIntChannel createPixelFilter(WritableIntChannel channel) {
                    SourceHandler.this.badPixelDetector = new BadPixelDetector(channel, SourceHandler.this.config.getBadPixelLowThreshold(), SourceHandler.this.config.getBadPixelHighThreshold());
                    return SourceHandler.this.badPixelDetector;
                }
            } : new FitsIntWriter(this.source, this.rebNode.getReb(), this.rebNode.getFitsService().getHeaderSpecificationMap(), namer, metaDataProvider){

                protected WritableIntChannel createPixelFilter(WritableIntChannel channel) {
                    SourceHandler.this.badPixelDetector = new BadPixelDetector(channel, SourceHandler.this.config.getBadPixelLowThreshold(), SourceHandler.this.config.getBadPixelHighThreshold());
                    return SourceHandler.this.badPixelDetector;
                }
            }) : (this.isStreaming ? new FitsIntWriter(this.source.getImage(), this.rebNode.getReb(), namer) : new FitsIntWriter(this.source, this.rebNode.getReb(), this.rebNode.getFitsService().getHeaderSpecificationMap(), namer, metaDataProvider));
            try (ByteChannel readChannel = this.source.openChannel(readThread.getStore(), this.isStreaming ? Source.ChannelMode.STREAM : Source.ChannelMode.READ);){
                int finalTotalBytes;
                int badPixels;
                ByteBuffer bb = ByteBuffer.allocateDirect(BUFFER_SIZE);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                Semaphore semaphore = readThread.getSemaphore();
                int totalBytes = 0;
                while (true) {
                    bb.clear();
                    semaphore.acquire();
                    try {
                        int l = readChannel.read(bb);
                        if (l < 0) break;
                        totalBytes += l;
                    }
                    finally {
                        semaphore.release();
                    }
                    bb.flip();
                    if (!decompress.isInitialized()) {
                        this.waitForDarkTime();
                        decompress.completeInitialization(this.source, this.rebNode.getFitsService().getHeaderSpecificationMap(), metaDataProvider);
                    }
                    decompress.write(bb.asIntBuffer());
                }
                if (this.badPixelDetector != null && (badPixels = this.badPixelDetector.getBadPixels()) > this.config.getBadPixelWarningLevel()) {
                    Level level = badPixels > this.config.getBadPixelAlarmLevel() ? Level.SEVERE : Level.WARNING;
                    result.addBadPixels(badPixels);
                    LOG.log(level, () -> String.format("Image %s source %s has %d bad pixels", this.source.getImage().getMetaData().getName(), this.source.getLocation(), badPixels));
                }
                if ((finalTotalBytes = totalBytes * 16 / 9) != decompress.getExpectedDataLength()) {
                    LOG.log(Level.WARNING, () -> String.format("Data length did not match expected (%,d != %,d)", finalTotalBytes, decompress.getExpectedDataLength()));
                }
            }
            catch (InterruptedException x) {
                io = new InterruptedIOException("Interrupt during IO");
                io.initCause(x);
                throw io;
            }
            catch (IOException x) {
                io = x;
                throw io;
            }
            finally {
                List filesToBeWritten = decompress.getFiles();
                IOException closeException = null;
                try {
                    decompress.close();
                }
                catch (IOException x) {
                    closeException = x;
                }
                if (filesToBeWritten != null) {
                    if (closeException != null || io != null) {
                        for (File file : filesToBeWritten) {
                            file.delete();
                        }
                    } else if (this.config.isUseTempFile()) {
                        for (File tempFile : filesToBeWritten) {
                            File finalName;
                            boolean success = tempFile.renameTo(finalName = (File)tmpMap.get(tempFile));
                            if (!success) {
                                throw new IOException("Unable to rename " + tempFile + " to " + finalName);
                            }
                            result.add((Object)finalName);
                        }
                    } else {
                        result.addAll((Collection)filesToBeWritten);
                    }
                }
                if (io == null && closeException != null) {
                    throw closeException;
                }
            }
            FileList fileList = result;
            return fileList;
        }
        catch (IOException | DAQException ioe) {
            throw new IOException("Exception for " + this.rebNode.getReb().getFullName(), ioe);
        }
        finally {
            this.rebNode.getFitsService().clearNonStickyHeaderKeywordValues();
            this.rebNode.updateState(ImageHandlingState.IDLE);
        }
    }

    private void waitForDarkTime() throws InterruptedException, IOException {
        if (this.darkTime.getCount() != 0L) {
            long start = System.nanoTime();
            boolean ok = this.darkTime.await(10L, TimeUnit.SECONDS);
            if (!ok) {
                throw new IOException("Timeout waiting for darkTime");
            }
            LOG.log(Level.FINE, () -> String.format("Waited %,dns for darkTime", System.nanoTime() - start));
        }
    }
}

