package org.lsst.ccs.subsystem.imagehandling;

import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;

/**
 *
 * @author tonyj
 */
public class ImageEventSender implements Runnable {

    private static final Logger LOG = Logger.getLogger(ImageEventSender.class.getName());

    private final FileList fileList;
    private final Agent agent;
    private final String imageName;
    private final LocationSet locations;
    private final Exception ex;

    public ImageEventSender(FileList fileList, Exception ex, Agent agent, LocationSet locations, String imageName) {
        this.fileList = fileList;
        this.ex = ex;
        this.agent = agent;
        this.imageName = imageName;
        this.locations = locations;
    }

    @Override
    public void run() {
        FitsFilesWrittenEvent event;
        if (fileList == null) {
            LOG.log(Level.SEVERE, "Unexpected exception waiting for file list", ex);
            event = new FitsFilesWrittenEvent(imageName, ex);
        } else {
            LOG.log(Level.INFO, "File list received {0}", fileList);
            event = new FitsFilesWrittenEvent(imageName, fileList, locations);
        }
        KeyValueData kvd = new KeyValueData(FitsFilesWrittenEvent.EVENT_KEY, event);
        agent.publishSubsystemDataOnStatusBus(kvd);
    }
}
