package org.lsst.ccs.subsystem.imagehandling;

import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.daq.ims.Source;

/**
 *
 * @author tonyj
 */
class ImageHandler implements Callable<FileList> {

    private final Image image;
    private final ImageHandlingConfig config;
    private final ExecutorService executor;
    private final List<RebNode> rebs;
    private final boolean isStreaming;
    private final CountDownLatch darkTime = new CountDownLatch(1);

    ImageHandler(Image image, ExecutorService executor, ImageHandlingConfig config, List<RebNode> rebs, boolean isStreaming) {
        this.image = image;
        this.config = config;
        this.executor = executor;
        this.rebs = rebs;
        this.isStreaming = isStreaming;
    }

    @Override
    public FileList call() throws IOException, DAQException, InterruptedException, ExecutionException {
        // Image has one source for each REB associated with the image
        List<Source> sources = image.listSources();
        Set<Location> locationsToProcess = config.getLocationsToProcess();
        List<Future<FileList>> lffl = new ArrayList<>();
        sources.stream()
                .filter((source) -> (locationsToProcess.contains(source.getLocation())))
                .forEach((source) -> {
                    Location location = source.getLocation();
                    for (RebNode r : rebs) {
                        if ( r.isEnabled() && r.getLocation().equals(location) ) {
                            lffl.add(executor.submit(new SourceHandler(darkTime, source, config, r, isStreaming)));                            
                        }
                    }
                });
        FileList result = new FileList();
        for (Future<FileList> ffl : lffl) {
            FileList fl = ffl.get();
            result.addAll(fl);
        }
        return result;
    }

    void darkTimeArrived() {
        darkTime.countDown();
    }
}
