/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.concurrent.Callable;
import nom.tam.fits.FitsException;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.states.ImageHandlingState;

public class SourceHandler
implements Callable<FileList> {
    private final Source source;
    private static final int BUFFER_SIZE = 0x100000;
    private final ImageHandlingConfig config;
    private final RebNode rebNode;

    SourceHandler(Source source, ImageHandlingConfig config, RebNode rebNode) {
        this.source = source;
        this.config = config;
        this.rebNode = rebNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileList call() throws IOException, DAQException, FitsException {
        this.rebNode.updateState(ImageHandlingState.READING);
        try {
            FileList result = new FileList();
            FitsIntWriter.FileNamer namer = props -> {
                File file = this.config.getFitsFile(props);
                result.add(file);
                return file;
            };
            FitsIntWriter.PerCCDMetaDataProvider metaDataProvider = ccd -> Collections.singletonList(this.rebNode.getFitsService().getFitsHeaderMetadataProvider(ccd.getUniqueId()));
            try (FitsIntWriter decompress = new FitsIntWriter(this.source, this.rebNode.getReb(), this.rebNode.getFitsService().getHeaderSpecificationMap(), namer, metaDataProvider);
                 ByteChannel readChannel = this.source.openChannel(Source.ChannelMode.READ);){
                int l;
                ByteBuffer bb = ByteBuffer.allocateDirect(0x100000);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                while ((l = readChannel.read(bb)) >= 0) {
                    bb.flip();
                    decompress.write(bb.asIntBuffer());
                    bb.clear();
                }
            }
            FileList fileList = result;
            return fileList;
        }
        finally {
            this.rebNode.updateState(ImageHandlingState.IDLE);
        }
    }
}

