/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class WcsCoordinatesFitsHeaderMetadataProvider
implements FitsHeaderMetadataProvider {
    private static final Map<CCD, List<Map<String, Object>>> wcsCoord = new ConcurrentHashMap<CCD, List<Map<String, Object>>>();
    private static final Logger LOG = Logger.getLogger(WcsCoordinatesFitsHeaderMetadataProvider.class.getName());
    private static final Pattern rangePattern = Pattern.compile(".*(\\[\\d+:\\d+(\\s*,\\s*)\\d+:\\d+\\])+.*");
    private final List<Map<String, Object>> props;

    public WcsCoordinatesFitsHeaderMetadataProvider(CCD ccd) {
        this.props = WcsCoordinatesFitsHeaderMetadataProvider.getWcsCoordinatesFor(ccd);
        if (this.props == null) {
            throw new RuntimeException("Could not find WCS coordinates for " + ccd.getUniqueId());
        }
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata() {
        MetaDataSet primaryHeaderMetadata = new MetaDataSet();
        primaryHeaderMetadata.addMetaDataMap("imageSet", this.props.get(0));
        return primaryHeaderMetadata;
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(int extendedIndex) {
        MetaDataSet extendedHeaderMetadata = new MetaDataSet();
        extendedHeaderMetadata.addMetaDataMap("channel", this.props.get(extendedIndex));
        return extendedHeaderMetadata;
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getWcsCoordinatesFor(CCD ccd) {
        Map<CCD, List<Map<String, Object>>> map = wcsCoord;
        synchronized (map) {
            if (!wcsCoord.containsKey(ccd)) {
                Raft r = (Raft)ccd.getParent();
                if (r == null) {
                    throw new RuntimeException("Cannot get WCS coordinates without the Raft information");
                }
                String ccdType = ccd.getType().getName().toLowerCase();
                if (ccdType.equals("wf")) {
                    ccdType = "itl";
                }
                String ccdFullName = r.getName() + "/" + ccd.getName();
                String fileName = "wcs/keywords_" + ccdType + "_" + r.getName() + ".wcs";
                LOG.log(Level.FINEST, "Opening wcs file {0} for CCD {0}.", new Object[]{fileName, ccdFullName});
                InputStream in = BootstrapResourceUtils.getBootstrapResource((String)fileName);
                if (in == null) {
                    throw new RuntimeException("Could not find wcs file " + fileName);
                }
                try {
                    Properties wcsFile = new Properties();
                    wcsFile.load(in);
                    String legend = wcsFile.getProperty("legend");
                    String[] wcsKeys = legend.split(",");
                    for (CCD c : r.getChildrenList()) {
                        ArrayList ccdWCSProviders = new ArrayList(c.getSegments().size());
                        for (Segment s : c.getSegments()) {
                            int i;
                            Matcher m;
                            String fullName = r.getName() + "/" + c.getName();
                            String segmentKey = fullName + "/" + s.getName().replace("Seg", "");
                            String segmentValue = wcsFile.getProperty(segmentKey);
                            HashMap<String, String> segmentWcsCoords = new HashMap<String, String>();
                            if (segmentValue == null) {
                                throw new RuntimeException("Null value for keyword: " + segmentKey + " in file " + fileName);
                            }
                            while ((m = rangePattern.matcher(segmentValue)).matches()) {
                                for (i = 1; i < m.groupCount(); ++i) {
                                    String group = m.group(i);
                                    String newGroup = group.replace(",", "!");
                                    segmentValue = segmentValue.replace(group, newGroup);
                                }
                            }
                            String[] wcsValues = segmentValue.split(", ");
                            if (wcsValues.length != wcsKeys.length) {
                                throw new RuntimeException("Inconsistent number of WCS values and keys in the legend: " + wcsValues.length + " " + wcsKeys.length);
                            }
                            for (i = 0; i < wcsValues.length; ++i) {
                                String wcsKey = wcsKeys[i].trim();
                                String wcsValue = wcsValues[i].trim();
                                wcsValue = wcsValue.replace("!", ",");
                                segmentWcsCoords.put(wcsKey, wcsValue);
                            }
                            ccdWCSProviders.add(segmentWcsCoords);
                        }
                        wcsCoord.put(c, ccdWCSProviders);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not load " + fileName, ioe);
                }
            }
            return wcsCoord.get(ccd);
        }
    }

    public static void main(String[] argv) throws Exception {
        FocalPlane fp = FocalPlane.createFocalPlane();
        for (Raft r : fp.getRafts()) {
            for (CCD ccd : r.getChildrenList()) {
                WcsCoordinatesFitsHeaderMetadataProvider wcsCoordinatesFitsHeaderMetadataProvider = new WcsCoordinatesFitsHeaderMetadataProvider(ccd);
            }
        }
    }
}

