/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;
import org.lsst.ccs.web.rest.file.server.data.VersionInfoV2;

public class VersionInfo
implements Serializable {
    private final int defaultVersion;
    private final int latestVersion;
    private final List<Version> versions;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public VersionInfo(@JsonProperty(value="default") int defaultVersion, @JsonProperty(value="latest") int latestVersion, @JsonProperty(value="versions") List<Version> versions) {
        this.defaultVersion = defaultVersion;
        this.latestVersion = latestVersion;
        this.versions = versions;
    }

    VersionInfo(VersionInfoV2 v2) {
        this.defaultVersion = v2.getDefault();
        this.latestVersion = v2.getLatest();
        ArrayList<Version> oldVersions = new ArrayList<Version>();
        for (VersionInfoV2.Version v : v2.getVersions()) {
            oldVersions.add(new Version(v));
        }
        this.versions = oldVersions;
    }

    public int getDefault() {
        return this.defaultVersion;
    }

    public int getLatest() {
        return this.latestVersion;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public String toString() {
        return "VersionInfo{defaultVersion=" + this.defaultVersion + ", latestVersion=" + this.latestVersion + ", versions=" + this.versions + '}';
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("latestVersion", this.getLatest());
        result.put("defaultVersion", this.getDefault());
        return result;
    }

    public static class Version
    extends RestFileInfo {
        private final int version;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public Version(@JsonProperty(value="lastModified") long lastModified, @JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="lastAccessTime") long lastAccessTime, @JsonProperty(value="size") long size, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="name") String name, @JsonProperty(value="fileKey") String fileKey, @JsonProperty(value="directory") boolean directory, @JsonProperty(value="other") boolean other, @JsonProperty(value="regularFile") boolean regularFile, @JsonProperty(value="symbolicLink") boolean symbolicLink, @JsonProperty(value="versionedFile") boolean versionedFile, @JsonProperty(value="children") List<RestFileInfo> children, @JsonProperty(value="version") int version) {
            super(lastModified, creationTime, lastAccessTime, size, mimeType, name, fileKey, directory, other, regularFile, symbolicLink, versionedFile, children);
            this.version = version;
        }

        public Version(Path file, BasicFileAttributes fileAttributes, int version) throws IOException {
            super(file, fileAttributes, false);
            this.version = version;
        }

        public Version(Version other) {
            super(other);
            this.version = other.version;
        }

        public Version(VersionInfoV2.Version v2) {
            super(v2);
            this.version = v2.getVersion();
        }

        public int getVersion() {
            return this.version;
        }
    }
}

