/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.DoNotTrend;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataDictionaryByType;
import org.lsst.ccs.services.DataDictionaryCompro;
import org.lsst.ccs.services.DataDictionaryOrdered;
import org.lsst.ccs.services.DataProviderDictionaryImpl;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.utilities.logging.Logger;

public final class DataProviderDictionaryService
implements ServiceLifecycle,
HasLifecycle,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MessagingService messagingService;
    private final List<DataProviderDictionaryListener> listeners = new CopyOnWriteArrayList<DataProviderDictionaryListener>();
    private ClientSideDataProviderDictionaryBookkeeper bookkeeper;
    private final ConcurrentHashMap<AgentInfo, DataProviderDictionary> agentDictionaries = new ConcurrentHashMap();
    private DataProviderDictionary dataProviderDictionary = new DataProviderDictionaryImpl();
    private byte[] serializedDataProviderDictionary;
    private final DataProviderDictionaryCommands dictionaryCommands = new DataProviderDictionaryCommands();
    private final AgentPresenceListener dictionaryServiceAgentPresenceManager = new DictionaryServiceAgentPresenceListener();
    private volatile boolean canAddToDictionary = true;
    private long dictionaryChecksum = -1L;

    @Override
    public String getAgentServiceName() {
        return "dataProviderDictionaryService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isGraphicalConsole() || agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void init() {
        this.agentCommandDictionaryService.addCommandSetToObject(this.dictionaryCommands, this.agent);
    }

    private static boolean needsDataProviderDictionary(AgentInfo agentInfo) {
        return agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.SERVICE) >= 0 || agentInfo.isGraphicalConsole();
    }

    @Override
    public void afterInit() {
        String dictionaryImplementation;
        TreeWalkerUtils.proceduralWalk(this.agent.getComponentLookup(), null, HasDataProviderInfos.class, hasDataProviderInfos -> {
            List<DataProviderInfo> sortedList = hasDataProviderInfos.getDataProviderInfos();
            for (DataProviderInfo dataProviderInfo : sortedList) {
                ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(dataProviderInfo);
            }
        }, hasDataProviderInfos -> hasDataProviderInfos.finalizeDictionary());
        HashMap<String, ArrayList<DataProviderInfo>> pathOfConfigurationsWithoutUnitsMap = new HashMap<String, ArrayList<DataProviderInfo>>();
        for (DataProviderInfo dataProviderInfo : this.dataProviderDictionary.getDataProviderInfos()) {
            String dataTypeAttr = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (dataTypeAttr == null || !dataTypeAttr.equals(DataProviderInfo.Type.CONFIGURATION.name()) || dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.UNITS) != null) continue;
            ArrayList<DataProviderInfo> configs = (ArrayList<DataProviderInfo>)pathOfConfigurationsWithoutUnitsMap.get(dataProviderInfo.getPath());
            if (configs == null) {
                configs = new ArrayList<DataProviderInfo>();
                pathOfConfigurationsWithoutUnitsMap.put(dataProviderInfo.getPath(), configs);
            }
            configs.add(dataProviderInfo);
        }
        for (Map.Entry entry : pathOfConfigurationsWithoutUnitsMap.entrySet()) {
            String path = (String)entry.getKey();
            DataProviderInfo monitoringChannel = null;
            for (DataProviderInfo info : this.dataProviderDictionary.getDataProviderInfos()) {
                String dataTypeAttr = info.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                if (dataTypeAttr == null || !dataTypeAttr.equals(DataProviderInfo.Type.MONITORING.name()) && !dataTypeAttr.equals(DataProviderInfo.Type.TRENDING.name()) || !info.getPath().equals(path)) continue;
                monitoringChannel = info;
                break;
            }
            if (monitoringChannel == null || monitoringChannel.getAttributeValue(DataProviderInfo.Attribute.UNITS) == null) continue;
            for (DataProviderInfo configPar : (List)entry.getValue()) {
                configPar.addAttribute(DataProviderInfo.Attribute.UNITS, monitoringChannel.getAttributeValue(DataProviderInfo.Attribute.UNITS));
            }
        }
        this.canAddToDictionary = false;
        switch (dictionaryImplementation = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.datadictionary.server", "ordered")) {
            case "ordered": {
                this.dataProviderDictionary = new DataDictionaryOrdered(this.dataProviderDictionary);
                break;
            }
            case "small": {
                this.dataProviderDictionary = new DataDictionaryByType(this.dataProviderDictionary, data -> new DataDictionaryCompro((List<DataProviderInfo>)data));
            }
        }
        this.dictionaryChecksum = ChecksumUtils.evaluateChecksum((Object)this.dataProviderDictionary);
        AgentInfo agentInfo = this.agent.getAgentInfo();
        agentInfo.getAgentProperties().setProperty(this.getClass().getSimpleName() + ":checksum", String.valueOf(this.dictionaryChecksum));
        String dictionaryType = null;
        if (agentInfo.isGraphicalConsole()) {
            dictionaryType = "console";
        } else if (agentInfo.isScriptingConsole()) {
            dictionaryType = "scripting";
        } else if (agentInfo.getType() == AgentInfo.AgentType.CONSOLE) {
            dictionaryType = "shell";
        }
        if (dictionaryType != null) {
            agentInfo.getAgentProperties().setProperty(this.getClass().getSimpleName() + ":type", dictionaryType);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Object object = null;
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(bos);){
                try (ObjectOutputStream oos = new ObjectOutputStream(gzipOut);){
                    oos.writeObject(this.dataProviderDictionary);
                    oos.flush();
                }
                this.serializedDataProviderDictionary = bos.toByteArray();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bos != null) {
                    if (object != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bos.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the dictionaries.", ioe);
        }
        if (DataProviderDictionaryService.needsDataProviderDictionary(this.agent.getAgentInfo())) {
            this.bookkeeper = new ClientSideDataProviderDictionaryBookkeeper();
            this.messagingService.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.bookkeeper, BusMessageFilterFactory.messageClass(StatusDataProviderDictionary.class));
            this.messagingService.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.bookkeeper);
        }
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.messagingService.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    public long getDictionaryChecksum() {
        return this.dictionaryChecksum;
    }

    @Override
    public void shutdown() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.messagingService.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    public void addDataProviderInfoToDictionary(DataProviderInfo info) {
        if (!this.canAddToDictionary) {
            throw new RuntimeException("Cannot add to DataProviderDictionary after the HasLifecycle::init phase");
        }
        ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(info);
    }

    public DataProviderDictionary getDataProviderDictionary() {
        return this.dataProviderDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProviderDictionary getDataProviderDictionaryForAgent(String agentName) {
        if (this.agent.getName().equals(agentName)) {
            return this.getDataProviderDictionary();
        }
        ConcurrentHashMap<AgentInfo, DataProviderDictionary> concurrentHashMap = this.agentDictionaries;
        synchronized (concurrentHashMap) {
            for (Map.Entry<AgentInfo, DataProviderDictionary> e : this.agentDictionaries.entrySet()) {
                if (!e.getKey().getName().equals(agentName)) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public void addMetadataForObject(KeyValueDataList data, String metadataName, String metadataValue, Object origin) {
        ComponentNode n = this.agent.getComponentLookup().getComponentNodeForObject(origin);
        if (n == null) {
            throw new RuntimeException("Cannot publish metadata for an Object that is not in the lookup tree.");
        }
        data.addData(n.getPath() + "/" + metadataName, (Serializable)((Object)String.valueOf(metadataValue)), KeyValueData.KeyValueDataType.KeyValueMetaData);
    }

    public void purge(AgentInfo agent) {
        this.agentDictionaries.remove(agent);
    }

    public void purge() {
        this.agentDictionaries.clear();
    }

    public void registerData(KeyValueData kvd) {
        StatusSubsystemData ssd = new StatusSubsystemData(kvd);
        KeyValueDataList list = ssd.getEncodedData();
        for (KeyValueData d : list) {
            this.doTheRegistration(d);
        }
    }

    public void registerClass(Class clazz) {
        this.registerClass(clazz, "");
    }

    public void registerClass(Class clazz, String path) {
        if (!this.canAddToDictionary) {
            throw new RuntimeException("Cannot register a Class after the HasLifecycle::init phase");
        }
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        List<Field> dataFields = this.getDataFieldsForClass(clazz);
        List<Annotation> classAttributes = this.getAnnotationsForClass(clazz, DataAttributes.class);
        List<Annotation> classTrend = this.getAnnotationsForClass(clazz, DoNotTrend.class);
        for (Field f : dataFields) {
            DataAttributes attributes = f.getAnnotation(DataAttributes.class);
            DoNotTrend trend = f.getAnnotation(DoNotTrend.class);
            String dataName = f.getName();
            if (dataName.startsWith("this$")) continue;
            String fullPath = !path.isEmpty() ? path + dataName : dataName;
            DataProviderInfo info = new DataProviderInfo(fullPath, DataProviderInfo.Type.TRENDING, fullPath);
            String units = "";
            String description = "";
            if (attributes != null) {
                if (!attributes.units().isEmpty()) {
                    units = attributes.units();
                }
                if (!attributes.description().isEmpty()) {
                    description = attributes.description();
                }
            }
            if (!classAttributes.isEmpty()) {
                ListIterator<Annotation> iter = classAttributes.listIterator(classAttributes.size());
                while (iter.hasPrevious()) {
                    DataAttributes attr = (DataAttributes)iter.previous();
                    if (units.isEmpty()) {
                        units = attr.units();
                    }
                    if (!description.isEmpty()) continue;
                    description = attr.description();
                }
            }
            if (!units.isEmpty()) {
                info.addAttribute(DataProviderInfo.Attribute.UNITS, units);
            }
            if (!description.isEmpty()) {
                info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, description);
            }
            if (trend != null || !classTrend.isEmpty()) {
                info.addAttribute(DataProviderInfo.Attribute.DO_NOT_TREND, "true");
            }
            Type fieldType = f.getGenericType();
            info.addAttribute(DataProviderInfo.Attribute.TYPE, fieldType.getTypeName());
            Class<?> fieldClass = f.getType();
            if (!(fieldClass.isPrimitive() || fieldClass.isArray() || fieldClass.equals(String.class) || Map.class.isAssignableFrom(fieldClass) || List.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass) || fieldClass.equals(BitSet.class) || fieldClass.equals(Boolean.class))) {
                String innerClassPath = path + "/" + dataName;
                innerClassPath = innerClassPath.replace("//", "/");
                this.registerClass(fieldClass, innerClassPath);
                continue;
            }
            ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(info);
        }
    }

    private List<Field> getDataFieldsForClass(Class clazz) {
        Field[] fields;
        ArrayList<Field> listFields = new ArrayList<Field>();
        if (clazz.getAnnotation(SkipEncoding.class) != null) {
            return listFields;
        }
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz)) {
            listFields.addAll(this.getDataFieldsForClass(superClazz));
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (field.getAnnotation(SkipEncoding.class) != null || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers)) continue;
            listFields.add(field);
        }
        return listFields;
    }

    private List<Annotation> getAnnotationsForClass(Class clazz, Class annotationClazz) {
        Object a;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz)) {
            annotations.addAll(this.getAnnotationsForClass(superClazz, annotationClazz));
        }
        if ((a = clazz.getAnnotation(annotationClazz)) != null) {
            annotations.add((Annotation)a);
        }
        return annotations;
    }

    private void doTheRegistration(KeyValueData kvd) {
        DataProviderInfo info = new DataProviderInfo(kvd.getKey(), DataProviderInfo.Type.TRENDING, kvd.getKey());
        ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataProviderDictionaryListener(DataProviderDictionaryListener listener) {
        ConcurrentHashMap<AgentInfo, DataProviderDictionary> concurrentHashMap = this.agentDictionaries;
        synchronized (concurrentHashMap) {
            for (Map.Entry<AgentInfo, DataProviderDictionary> entry : this.agentDictionaries.entrySet()) {
                listener.dataProviderDictionaryUpdate(new DataProviderDictionaryEvent(entry.getKey(), DataProviderDictionaryEvent.EventType.ADDED, entry.getValue()));
            }
            this.listeners.add(listener);
        }
    }

    public void removeDataProviderDictionaryListener(DataProviderDictionaryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyDataProviderDictionaryListeners(DataProviderDictionaryEvent evt) {
        for (DataProviderDictionaryListener listener : this.listeners) {
            try {
                listener.dataProviderDictionaryUpdate(evt);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Caught exception notifying dictionary listerer " + listener.getClass(), (Throwable)e);
            }
        }
    }

    private class ClientSideDataProviderDictionaryBookkeeper
    implements StatusMessageListener,
    AgentPresenceListener {
        private final String dictionaryImplementation = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.datadictionary.client", "");

        private ClientSideDataProviderDictionaryBookkeeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected(AgentInfo ... agents) {
            ConcurrentHashMap concurrentHashMap = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (concurrentHashMap) {
                for (AgentInfo agent : agents) {
                    DataProviderDictionary dict = (DataProviderDictionary)DataProviderDictionaryService.this.agentDictionaries.remove(agent);
                    if (dict == null) continue;
                    DataProviderDictionaryService.this.notifyDataProviderDictionaryListeners(new DataProviderDictionaryEvent(agent, DataProviderDictionaryEvent.EventType.REMOVED, dict));
                }
            }
        }

        public void onStatusMessage(StatusMessage msg) {
            if (DataProviderDictionaryService.this.agent.getName().equals(msg.getOriginAgentInfo().getName())) {
                return;
            }
            AgentInfo agentInfo = msg.getOriginAgentInfo();
            this.addDataProviderDictionary(agentInfo, ((StatusDataProviderDictionary)msg).getDataProviderDictionary());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDataProviderDictionary(AgentInfo agent, DataProviderDictionary dictionary) {
            switch (this.dictionaryImplementation) {
                case "small": {
                    if (dictionary instanceof DataDictionaryByType) break;
                    log.info((Object)("Converting data dictionary for " + agent.getName() + " from " + dictionary.getClass().getSimpleName() + " to DataDictionaryByType<DataDictionaryCompro>"));
                    dictionary = new DataDictionaryByType(dictionary, data -> new DataDictionaryCompro((List<DataProviderInfo>)data));
                    break;
                }
                case "fast": {
                    if (dictionary instanceof DataProviderDictionaryImpl) break;
                    log.info((Object)("Converting data dictionary for " + agent.getName() + " from " + dictionary.getClass().getSimpleName() + " to DataProviderDictionaryImpl"));
                    DataProviderDictionaryImpl dict = new DataProviderDictionaryImpl();
                    dictionary.getDataProviderInfos().forEach(dpi -> dict.addDataProviderInfo((DataProviderInfo)dpi));
                    break;
                }
                default: {
                    log.info((Object)("Storing data dictionary of type " + dictionary.getClass().getSimpleName() + " from " + agent.getName()));
                }
            }
            Object object = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (object) {
                if (!DataProviderDictionaryService.this.agentDictionaries.containsKey(agent)) {
                    DataProviderDictionaryService.this.agentDictionaries.put(agent, dictionary);
                    DataProviderDictionaryService.this.notifyDataProviderDictionaryListeners(new DataProviderDictionaryEvent(agent, DataProviderDictionaryEvent.EventType.ADDED, dictionary));
                }
            }
        }
    }

    public static class DataProviderDictionaryEvent {
        private final EventType eventType;
        private final AgentInfo agentInfo;
        private final DataProviderDictionary dictionary;

        DataProviderDictionaryEvent(AgentInfo agentInfo, EventType eventType, DataProviderDictionary dictionary) {
            this.eventType = eventType;
            this.agentInfo = agentInfo;
            this.dictionary = dictionary;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public AgentInfo getAgentInfo() {
            return this.agentInfo;
        }

        public DataProviderDictionary getDictionary() {
            return this.dictionary;
        }

        public static enum EventType {
            ADDED,
            REMOVED;

        }
    }

    public static interface DataProviderDictionaryListener {
        public void dataProviderDictionaryUpdate(DataProviderDictionaryEvent var1);
    }

    class DictionaryServiceAgentPresenceListener
    implements AgentPresenceListener {
        DictionaryServiceAgentPresenceListener() {
        }

        public void connecting(AgentInfo ... agents) {
            boolean needsPublication = false;
            for (AgentInfo info : agents) {
                if (!DataProviderDictionaryService.needsDataProviderDictionary(info)) continue;
                needsPublication = true;
            }
            if (needsPublication) {
                DataProviderDictionaryService.this.dictionaryCommands.publishDataProviderDictionaryForAgent(agents);
            }
        }

        public void connected(AgentInfo ... agents) {
            boolean needsPublication = false;
            for (AgentInfo info : agents) {
                if (!DataProviderDictionaryService.needsDataProviderDictionary(info)) continue;
                needsPublication = true;
            }
            if (needsPublication) {
                DataProviderDictionaryService.this.dictionaryCommands.publishDataProviderCurrentDataForAgent(agents);
            }
        }
    }

    public class DataProviderDictionaryCommands {
        private void publishDataProviderDictionaryForAgent(AgentInfo ... agentInfo) {
            if (DataProviderDictionaryService.this.serializedDataProviderDictionary == null) {
                throw new RuntimeException("The DataProviderInfo dictionary is not ready yet for publication");
            }
            DataProviderDictionaryService.this.agent.sendStatusMessage((StatusMessage)new StatusDataProviderDictionary(DataProviderDictionaryService.this.serializedDataProviderDictionary, "gzip"));
        }

        @Command(description="Publish on the status bus the Agent's dictionary of data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderDictionary() {
            this.publishDataProviderDictionaryForAgent(new AgentInfo[0]);
            this.publishDataProviderCurrentDataForAgent(new AgentInfo[0]);
        }

        private void publishDataProviderCurrentDataForAgent(AgentInfo ... agentInfos) {
            TreeWalkerUtils.proceduralWalk(DataProviderDictionaryService.this.agent.getComponentLookup(), null, HasDataProviderInfos.class, hasDataProviderInfos -> hasDataProviderInfos.publishDataProviderCurrentData(agentInfos), null);
        }

        @Command(description="Publish on the status bus the Agent's current data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderCurrentData() {
            this.publishDataProviderCurrentDataForAgent(new AgentInfo[0]);
        }

        @Command(description="Show the trending data in a group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public String printDataProviderDictionary() {
            StringBuilder sb = new StringBuilder();
            for (DataProviderInfo info : DataProviderDictionaryService.this.dataProviderDictionary.getDataProviderInfos()) {
                sb.append(info.toString()).append("\n");
            }
            return sb.toString();
        }
    }
}

