/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.cachedstore;

import com.mchange.v1.cachedstore.CachedStore;
import com.mchange.v1.cachedstore.CachedStoreException;
import com.mchange.v1.cachedstore.TweakableCachedStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class NoCleanupCachedStore
implements TweakableCachedStore {
    static final boolean DEBUG = true;
    protected Map cache = new HashMap();
    CachedStore.Manager manager;

    public NoCleanupCachedStore(CachedStore.Manager manager) {
        this.manager = manager;
    }

    public Object find(Object key) throws CachedStoreException {
        try {
            Object out = this.getCachedValue(key);
            if ((out == null || this.manager.isDirty(key, out)) && (out = this.manager.recreateFromKey(key)) != null) {
                this.setCachedValue(key, out);
            }
            return out;
        }
        catch (CachedStoreException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CachedStoreException(e);
        }
    }

    public Object getCachedValue(Object key) {
        return this.cache.get(key);
    }

    public void removeFromCache(Object key) throws CachedStoreException {
        this.cache.remove(key);
    }

    public void setCachedValue(Object key, Object value) throws CachedStoreException {
        this.cache.put(key, value);
    }

    public Iterator cachedKeys() throws CachedStoreException {
        return this.cache.keySet().iterator();
    }

    public void reset() {
        this.cache.clear();
    }
}

