/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.CoreStates;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.services.lock.Locker;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Browser
implements Savable {
    protected final Logger logger = Console.getConsole().getLogger();
    protected final LockService service = LockService.getService();
    protected JPanel browserPanel;
    ImageIcon ICON_UNLOCKED_BLACK = new ImageIcon(Browser.class.getResource("ic_lock_open_black_18dp.png"), "unlocked black");
    ImageIcon ICON_LOCKED_BLACK = new ImageIcon(Browser.class.getResource("ic_lock_black_18dp.png"), "locked black");
    ImageIcon ICON_UNLOCKED_RED = new ImageIcon(Browser.class.getResource("red_unlocked_27.png"), "unlocked red");
    ImageIcon ICON_LOCKED_RED = new ImageIcon(Browser.class.getResource("red_locked_27.png"), "locked red");
    ImageIcon ICON_UNLOCKED_GREEN = new ImageIcon(Browser.class.getResource("green_unlocked_27.png"), "unlocked green");
    ImageIcon ICON_LOCKED_GREEN = new ImageIcon(Browser.class.getResource("green_locked_27.png"), "locked green");
    ImageIcon ICON_UNLOCKED_GRAY = new ImageIcon(Browser.class.getResource("gray_unlocked_27.png"), "unlocked gray");
    ImageIcon ICON_LOCKED_GRAY = new ImageIcon(Browser.class.getResource("gray_locked_27.png"), "locked gray");
    protected JLabel stateLabel;
    private AgentStatusListener statusListener;
    private final AgentStatusAggregator statusAggregator = Console.getConsole().getStatusAggregator();

    public JComponent getPanel() {
        this.stateLabel = new JLabel(" ");
        this.statusListener = new AgentStatusListener(){

            @Override
            public void connect(AgentStatusEvent event) {
                SwingUtilities.invokeLater(() -> Browser.this.updateStateDisplay());
            }

            @Override
            public void disconnect(AgentStatusEvent event) {
                SwingUtilities.invokeLater(() -> Browser.this.updateStateDisplay());
            }

            @Override
            public void statusChanged(AgentStatusEvent event) {
                SwingUtilities.invokeLater(() -> Browser.this.updateStateDisplay());
            }
        };
        String agentName = this.getAgentName();
        List<String> agents = agentName == null ? null : Collections.singletonList(agentName);
        this.statusAggregator.addListener(this.statusListener, agents, CoreStates.CHANNELS);
        this.browserPanel = new JPanel(new BorderLayout());
        return this.browserPanel;
    }

    public void shutdown() {
        this.statusAggregator.removeListener(this.statusListener);
        this.browserPanel = null;
    }

    abstract String getName();

    abstract String getAgentName();

    public static boolean isCommandLocked(DictionaryCommand command, Locker agent) {
        if (agent == null) {
            return true;
        }
        return command.getLevel() > agent.getLevel() || agent.getState() != LockService.State.ATTACHED && command.getType() != Command.CommandType.QUERY;
    }

    protected void updateStateDisplay() {
        CommandState com;
        AlertState als;
        ConfigurationState con;
        OperationalState ops;
        String agentName = this.getAgentName();
        if (agentName == null) {
            this.stateLabel.setText(" ");
            return;
        }
        StateBundle state = this.statusAggregator.getAgentState(agentName);
        if (state == null) {
            this.stateLabel.setText("OFFLINE");
            return;
        }
        StringBuilder sb = new StringBuilder("<html>");
        PhaseState phase = (PhaseState)state.getState(PhaseState.class);
        if (phase != null) {
            sb.append(phase).append(" - ");
        }
        if ((ops = (OperationalState)state.getState(OperationalState.class)) != null) {
            switch (ops) {
                case NORMAL: {
                    sb.append("<font color=\"#008800\">NORMAL</font>");
                    break;
                }
                case ENGINEERING_FAULT: {
                    sb.append("<font color=\"#DD0000\">ENGINEERING_FAULT</font>");
                    break;
                }
                default: {
                    sb.append(ops);
                }
            }
            sb.append(" - ");
        }
        if ((con = (ConfigurationState)state.getState(ConfigurationState.class)) != null) {
            switch (con) {
                case DIRTY: {
                    sb.append("<font color=\"#0000DD\">MODIFIED CONFIGURATION</font>");
                    break;
                }
                default: {
                    sb.append(con);
                }
            }
            sb.append(" - ");
        }
        if ((als = (AlertState)state.getState(AlertState.class)) != null && !als.equals((Object)AlertState.NOMINAL)) {
            switch (als) {
                case WARNING: {
                    sb.append("<font color=\"#0000DD\">WARNING</font>");
                    break;
                }
                case ALARM: {
                    sb.append("<font color=\"#DD0000\">ALARM</font>");
                }
            }
            sb.append(" - ");
        }
        if ((com = (CommandState)state.getState(CommandState.class)) != null) {
            switch (com) {
                case READY: {
                    sb.append("<font color=\"#008800\">READY</font>");
                    break;
                }
                case ACTIVE: {
                    sb.append("<font color=\"#DD0000\">ACTIVE</font>");
                }
            }
        }
        this.stateLabel.setText(sb.toString());
    }

    protected Action getAction(final String agentName, final LockService.Operation operation) {
        AbstractAction act = new AbstractAction(operation.toString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                Browser.this.service.executeOperation(operation, agentName, 0);
            }
        };
        act.putValue("ShortDescription", (Object)((Object)operation) + " " + agentName);
        return act;
    }

    protected RenderedLock renderLock(Locker agent) {
        RenderedLock out = new RenderedLock();
        if (agent == null) {
            out.icon = this.ICON_UNLOCKED_GRAY;
            out.tooltip = "Subsystem offline, unlocked";
            out.enabled = true;
        } else {
            out.enabled = !agent.isAdjusting();
            switch (agent.getState()) {
                case UNLOCKED: {
                    out.icon = this.ICON_UNLOCKED_BLACK;
                    out.tooltip = "Double-click lo lock";
                    out.defaultAction = this.getAction(agent.getName(), LockService.Operation.LOCK);
                    out.availableActions = Collections.singletonList(out.defaultAction);
                    break;
                }
                case LOCKED: {
                    out.icon = this.ICON_LOCKED_BLACK;
                    out.tooltip = "Locked by " + agent.getLock().getOwner();
                    out.defaultAction = null;
                    out.availableActions = Collections.singletonList(this.getAction(agent.getName(), LockService.Operation.DESTROY));
                    break;
                }
                case DETACHED: {
                    out.icon = this.ICON_LOCKED_RED;
                    out.tooltip = "Locked, double-click to attach";
                    out.defaultAction = this.getAction(agent.getName(), LockService.Operation.ATTACH);
                    out.availableActions = Arrays.asList(this.getAction(agent.getName(), LockService.Operation.UNLOCK), out.defaultAction);
                    break;
                }
                case ATTACHED: {
                    out.icon = this.ICON_LOCKED_GREEN;
                    out.tooltip = "Locked, attached, double-click to detach";
                    out.defaultAction = this.getAction(agent.getName(), LockService.Operation.DETACH);
                    out.availableActions = Arrays.asList(this.getAction(agent.getName(), LockService.Operation.UNLOCK), out.defaultAction);
                }
            }
            if (!out.enabled) {
                out.tooltip = "Waiting for response from Lock Manager";
                out.defaultAction = null;
                out.availableActions = null;
            }
        }
        return out;
    }

    @Override
    public abstract Descriptor save();

    public static class Descriptor
    implements Serializable {
        private String name;
        private String agent;
        private AgentPanel.Descriptor agentPanel;
        private DataPanelDescriptor page;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAgent() {
            return this.agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public AgentPanel.Descriptor getAgentPanel() {
            return this.agentPanel;
        }

        public void setAgentPanel(AgentPanel.Descriptor agentPanel) {
            this.agentPanel = agentPanel;
        }

        public DataPanelDescriptor getPage() {
            return this.page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }
    }

    protected static class RenderedLock {
        public ImageIcon icon;
        public String tooltip;
        public boolean enabled;
        public Action defaultAction;
        public List<Action> availableActions;

        public RenderedLock(ImageIcon icon, String tooltip, boolean enabled, Action defaultAction, List<Action> availableActions) {
            this.icon = icon;
            this.tooltip = tooltip;
            this.enabled = enabled;
            this.defaultAction = defaultAction;
            this.availableActions = availableActions;
        }

        public RenderedLock() {
        }
    }
}

