/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.ServerResource;
import org.astrogrid.samp.web.OriginAuthorizer;

public class OpenPolicyResourceHandler
implements HttpServer.Handler {
    private final String policyPath_;
    private final ServerResource policyResource_;
    private final OriginAuthorizer authorizer_;
    private final HttpServer.Response response405_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OpenPolicyResourceHandler(String policyPath, ServerResource policyResource, OriginAuthorizer authorizer) {
        this.policyPath_ = policyPath;
        this.policyResource_ = policyResource;
        this.authorizer_ = authorizer;
        this.response405_ = HttpServer.create405Response(new String[]{"GET", "HEAD"});
    }

    public HttpServer.Response serveRequest(HttpServer.Request request) {
        if (request.getUrl().equals(this.policyPath_)) {
            String method = request.getMethod();
            if (!method.equals("HEAD") && !method.equals("GET")) {
                return this.response405_;
            }
            if (this.authorizer_.authorizeAll()) {
                LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
                hdrMap.put("Content-Type", this.policyResource_.getContentType());
                long contentLength = this.policyResource_.getContentLength();
                if (contentLength >= 0L) {
                    hdrMap.put("Content-Length", Long.toString(contentLength));
                }
                if (method.equals("HEAD")) {
                    return new HttpServer.Response(200, "OK", hdrMap){

                        public void writeBody(OutputStream out) {
                        }
                    };
                }
                if (method.equals("GET")) {
                    return new HttpServer.Response(200, "OK", hdrMap){

                        public void writeBody(OutputStream out) throws IOException {
                            OpenPolicyResourceHandler.this.policyResource_.writeBody(out);
                        }
                    };
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return this.response405_;
            }
            return HttpServer.createErrorResponse(404, "Not found");
        }
        return null;
    }

    public static HttpServer.Handler createPolicyHandler(String path, URL contentUrl, String contentType, OriginAuthorizer oAuth) throws IOException {
        ServerResource resource = OpenPolicyResourceHandler.createCachedResource(contentUrl, contentType);
        return new OpenPolicyResourceHandler(path, resource, oAuth);
    }

    public static HttpServer.Handler createFlashPolicyHandler(OriginAuthorizer oAuth) throws IOException {
        return OpenPolicyResourceHandler.createPolicyHandler("/crossdomain.xml", OpenPolicyResourceHandler.class.getResource("crossdomain.xml"), "text/x-cross-domain-policy", oAuth);
    }

    public static HttpServer.Handler createSilverlightPolicyHandler(OriginAuthorizer oAuth) throws IOException {
        return OpenPolicyResourceHandler.createPolicyHandler("/clientaccesspolicy.xml", OpenPolicyResourceHandler.class.getResource("clientaccesspolicy.xml"), "text/xml", oAuth);
    }

    private static ServerResource createCachedResource(URL dataUrl, final String contentType) throws IOException {
        int count;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream uin = dataUrl.openStream();
        byte[] buf = new byte[1024];
        while ((count = uin.read(buf)) >= 0) {
            bout.write(buf, 0, count);
        }
        bout.close();
        final byte[] data = bout.toByteArray();
        return new ServerResource(){

            public long getContentLength() {
                return data.length;
            }

            public String getContentType() {
                return contentType;
            }

            public void writeBody(OutputStream out) throws IOException {
                out.write(data);
            }
        };
    }

    static {
        $assertionsDisabled = !OpenPolicyResourceHandler.class.desiredAssertionStatus();
    }
}

