/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.RandomAccess;

public final class FitsUtil {
    private static final int BYTE_REPRESENTING_BLANK = 32;
    private static final int BYTE_REPRESENTING_MAX_ASCII_VALUE = 126;
    private static final Logger LOG = Logger.getLogger(FitsUtil.class.getName());
    private static boolean wroteCheckingError = false;

    private FitsUtil() {
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    public static long addPadding(long size) {
        return size + (long)FitsUtil.padding(size);
    }

    static byte[] booleanToByte(boolean[] bool) {
        byte[] byt = new byte[bool.length];
        for (int i = 0; i < bool.length; ++i) {
            byt[i] = bool[i] ? 84 : 70;
        }
        return byt;
    }

    public static String[] byteArrayToStrings(byte[] bytes, int maxLen) {
        boolean checking = FitsFactory.getCheckAsciiStrings();
        String[] res = new String[bytes.length / maxLen];
        for (int i = 0; i < res.length; ++i) {
            int start;
            int end = start + maxLen;
            for (start = i * maxLen; start < end && bytes[start] == 32; ++start) {
            }
            while (end > start && bytes[end - 1] == 32) {
                --end;
            }
            boolean errFound = false;
            for (int j = start; j < end; ++j) {
                if (bytes[j] == 0) {
                    end = j;
                    break;
                }
                if (!checking || bytes[j] >= 32 && bytes[j] <= 126) continue;
                errFound = true;
                bytes[j] = 32;
            }
            res[i] = AsciiFuncs.asciiString(bytes, start, end - start);
            if (!errFound || wroteCheckingError) continue;
            LOG.log(Level.SEVERE, "Warning: Invalid ASCII character[s] detected in string: " + res[i] + " Converted to space[s].  Any subsequent invalid characters will be converted silently");
            wroteCheckingError = true;
        }
        return res;
    }

    static boolean[] byteToBoolean(byte[] bytes) {
        boolean[] bool = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bool[i] = bytes[i] == 84;
        }
        return bool;
    }

    public static long findOffset(Closeable o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static InputStream getURLStream(URL url, int level) throws IOException {
        URLConnection conn = null;
        int code = -1;
        try {
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                code = ((HttpURLConnection)conn).getResponseCode();
            }
            return conn.getInputStream();
        }
        catch (ProtocolException e) {
            LOG.log(Level.WARNING, "could not connect to " + url + (code >= 0 ? " got responce-code" + code : ""), e);
            throw e;
        }
    }

    public static int maxLength(String[] strings) throws FitsException {
        int max = 0;
        for (String element : strings) {
            if (element == null || element.length() <= max) continue;
            max = element.length();
        }
        return max;
    }

    public static void pad(ArrayDataOutput stream, long size) throws FitsException {
        FitsUtil.pad(stream, size, (byte)0);
    }

    public static void pad(ArrayDataOutput stream, long size, byte fill) throws FitsException {
        int len = FitsUtil.padding(size);
        if (len > 0) {
            byte[] buf = new byte[len];
            Arrays.fill(buf, fill);
            try {
                stream.write(buf);
                stream.flush();
            }
            catch (Exception e) {
                throw new FitsException("Unable to write padding", e);
            }
        }
    }

    public static int padding(int size) {
        return FitsUtil.padding((long)size);
    }

    public static int padding(long size) {
        int mod = (int)(size % 2880L);
        if (mod > 0) {
            mod = 2880 - mod;
        }
        return mod;
    }

    public static void reposition(Closeable o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + "   Exception:" + e.getMessage(), e);
        }
    }

    public static byte[] stringsToByteArray(String[] stringArray, int maxLen) {
        byte[] res = new byte[stringArray.length * maxLen];
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] bstr = stringArray[i] == null ? new byte[]{} : AsciiFuncs.getBytes(stringArray[i]);
            int cnt = bstr.length;
            if (cnt > maxLen) {
                cnt = maxLen;
            }
            System.arraycopy(bstr, 0, res, i * maxLen, cnt);
            for (int j = cnt; j < maxLen; ++j) {
                res[i * maxLen + j] = 32;
            }
        }
        return res;
    }
}

