/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsbase.util.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.RegisterableService;
import org.freehep.graphicsbase.util.Service;
import org.freehep.graphicsbase.util.export.ExportFileType;

public class ExportFileTypeRegistry {
    private static ExportFileTypeRegistry registry;
    private static ClassLoader loader;
    private List<ExportFileType> extraTypes = new ArrayList<ExportFileType>();
    private static final Collection<Class<?>> categories;

    private ExportFileTypeRegistry() {
    }

    public static synchronized ExportFileTypeRegistry getDefaultInstance(ClassLoader loader) {
        if (loader != null && loader != ExportFileTypeRegistry.loader) {
            if (ExportFileTypeRegistry.loader != null) {
                throw new RuntimeException(ExportFileTypeRegistry.class.getName() + ": Different classloader was already used in getDefaultInstance");
            }
            ExportFileTypeRegistry.loader = loader;
        }
        if (registry == null) {
            registry = new ExportFileTypeRegistry();
            registry.addApplicationClasspathExportFileTypes();
        }
        return registry;
    }

    public List<ExportFileType> get() {
        return this.get(null);
    }

    public List<ExportFileType> get(String format) {
        ArrayList<ExportFileType> export = new ArrayList<ExportFileType>();
        this.addExportFileTypeToList(export, format, this.extraTypes.iterator());
        return export;
    }

    public void add(ExportFileType exportFileType) {
        this.extraTypes.add(exportFileType);
    }

    private void addExportFileTypeToList(List<ExportFileType> list, String format, Iterator<?> iterator) {
        block0: while (iterator.hasNext()) {
            ExportFileType type = (ExportFileType)iterator.next();
            if (format == null) {
                if (list.contains(type)) continue;
                list.add(type);
                continue;
            }
            String[] ext = type.getExtensions();
            for (int i = 0; i < ext.length; ++i) {
                if (!ext[i].equalsIgnoreCase(format)) continue;
                if (list.contains(type)) continue block0;
                list.add(type);
                continue block0;
            }
        }
    }

    private void addApplicationClasspathExportFileTypes() {
        ClassLoader classLoader = loader != null ? loader : Thread.currentThread().getContextClassLoader();
        for (Class<?> category : categories) {
            for (Object current : Service.providers(category, classLoader)) {
                if (current instanceof RegisterableService) {
                    try {
                        ((RegisterableService)current).onRegistration(null, category);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (!(current instanceof ExportFileType)) continue;
                this.extraTypes.add((ExportFileType)current);
            }
        }
    }

    static {
        categories = new ArrayList(2);
        categories.add(ExportFileType.class);
        categories.add(RegisterableService.class);
    }
}

