/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView2;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class CompoundView
extends AbstractMonitorView1 {
    protected Descriptor descriptor = new Descriptor();
    private final JComponent panel;
    private final ArrayList<PersistableMonitorView> children1 = new ArrayList(0);
    private final ArrayList<PersistableMonitorView> children2 = new ArrayList(0);
    private final ArrayList<AbstractMonitorView2> children3 = new ArrayList(0);

    public CompoundView(JComponent panel) {
        this.panel = panel;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        super.setFilter(filter);
        this.children1.forEach(child -> child.setFilter(filter));
        this.children2.forEach(child -> child.setFilter(filter));
    }

    public void addView(PersistableMonitorView view, Mode mode) {
        switch (mode) {
            case INDEPENDENT: {
                this.children1.add(view);
                break;
            }
            case FORWARD: {
                this.children2.add(view);
                break;
            }
            case HOOK: {
                try {
                    this.children3.add((AbstractMonitorView2)view);
                    break;
                }
                catch (ClassCastException x) {
                    throw new IllegalArgumentException("HOOK mode can only be used to manage views of types that extend AbstractMonitorView", x);
                }
            }
        }
    }

    @Override
    public void connect(AgentStatusEvent event) {
        super.connect(event);
        this.children2.forEach(view -> view.connect(event.filter(view.getFilter())));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        super.configure(event);
        this.children2.forEach(view -> view.configure(event.filter(view.getFilter())));
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        super.statusChanged(event);
        this.children2.forEach(view -> view.statusChanged(event.filter(view.getFilter())));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        super.disconnect(event);
        this.children2.forEach(view -> view.disconnect(event.filter(view.getFilter())));
    }

    @Override
    protected void connect(AgentInfo agent) {
        this.children3.forEach(view -> view.connect(agent));
    }

    @Override
    protected void disconnect(AgentInfo agent) {
        this.children3.forEach(view -> view.disconnect(agent));
    }

    @Override
    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        this.children3.forEach(view -> view.addChannels(agent, channels));
    }

    @Override
    protected void removeChannels(AgentInfo agent, List<String> paths) {
        this.children3.forEach(view -> view.removeChannels(agent, paths));
    }

    @Override
    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        this.children3.forEach(view -> view.updateChannels(agent, channels));
    }

    @Override
    public void install() {
        super.install();
        this.children1.forEach(view -> view.install());
    }

    @Override
    public void uninstall() {
        super.uninstall();
        this.children1.forEach(view -> view.uninstall());
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        ArrayList<PersistableMonitorView> views = this.getChildren();
        Persistable.Descriptor[] cd = new Persistable.Descriptor[views.size()];
        for (int i = 0; i < cd.length; ++i) {
            cd[i] = ((PersistableMonitorView)views.get(i)).save();
        }
        desc.setChildren(cd);
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        ArrayList<PersistableMonitorView> vv;
        Descriptor desc;
        Persistable.Descriptor[] dd;
        if (descriptor instanceof Descriptor && (dd = (desc = (Descriptor)descriptor).getChildren()) != null && dd.length == (vv = this.getChildren()).size()) {
            for (int i = 0; i < dd.length; ++i) {
                ((PersistableMonitorView)vv.get(i)).restore(dd[i]);
            }
        }
    }

    private ArrayList<PersistableMonitorView> getChildren() {
        ArrayList<PersistableMonitorView> out = new ArrayList<PersistableMonitorView>(this.children1.size() + this.children2.size() + this.children3.size());
        out.addAll(this.children1);
        out.addAll(this.children2);
        out.addAll(this.children3);
        return out;
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private Persistable.Descriptor[] children;

        public Persistable.Descriptor[] getChildren() {
            return this.children;
        }

        public void setChildren(Persistable.Descriptor[] children) {
            this.children = children;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.children != null) {
                desc.children = (Persistable.Descriptor[])desc.children.clone();
            }
            return desc;
        }
    }

    public static enum Mode {
        INDEPENDENT,
        FORWARD,
        HOOK;

    }
}

