package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;

/**
 * An object representing an additional data file to be written into the image
 * output directory by the "primary" image handler, and sent to USDF.
 *
 * @author tonyj
 */
@SkipEncoding
public abstract class AdditionalFile implements Serializable {

    private final String fileName;
    private final String fileType;
    private final ImageName obsId;
    private static final long serialVersionUID = 1;
    public static final String EVENT_KEY = "additionalFile";

    public AdditionalFile(String fileName, String fileType, ImageName obsId) {
        this.fileName = fileName;
        this.obsId = obsId;
        this.fileType = fileType;
    }

    public String getFileName() {
        return fileName;
    }

    public ImageName getObsId() {
        return obsId;
    }

    public String getFileType() {
        return fileType;
    }

    public abstract void writeFile(OutputStream out) throws IOException;

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writeFile(baos);
            baos.close();
            return baos.toString();
        } catch (IOException x) {
            return x.toString();
        }
    }
    
    
}
