package org.lsst.ccs.subsystem.imagehandling.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;

/**
 * An AdditionalFile with data to be written as JSON.
 * @author tonyj
 */
@SkipEncoding
public class JsonFile extends AdditionalFile {

    private final Object data;
    private final String dataName;
    private static final long serialVersionUID = 1;

    public JsonFile(String fileName, String fileType, ImageName obsId, String dataName, Object data) {
        super(fileName, fileType, obsId);
        this.dataName = dataName;
        this.data = data;
    }

    @Override
    public void writeFile(OutputStream out) throws IOException {
        Map<Object, Object> jsonData = new LinkedHashMap<>();
        jsonData.put("fileName", super.getFileName());
        jsonData.put("fileType", super.getFileType());
        jsonData.put("obsId", super.getObsId().toString());
        jsonData.put(dataName, data);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(out, jsonData);
    }
}
