package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.utilities.location.LocationSet;

/**
 * This event is sent by focal-plane when it wants to trigger a simulated DAQ
 * image This is currently only used when running AuxTel on BTS (where there is
 * no DAQ)
 *
 * @author tonyj
 */
@SkipEncoding
public class TriggerSimulatedImage implements Serializable {
    
    private static final long serialVersionUID = 1;
    
    public static final String EVENT_KEY = "triggerSimulatedImage";

    private final String triggeredImageName;
    private final LocationSet locations;
    private final String annotation;
    private final int opCode;
    private final String triggeredDAQFolder;
    private final String emulatedImageName;
    private final String emulatedDAQFolder;
    private final String emulatedDataFolder;

    /**
     * Create a TriggerSimulatedImage event
     * @param triggeredImageName The name of the triggeredImage
     * @param triggeredDAQFolder The DAQ folder where the triggeredImage will be written (e.g. raw) 
     * @param emulatedImageName The name of the emulated (input) image
     * @param emulatedDAQFolder The name of the DAQ folder with the emulated image
     * @param emulatedDataFolder The directory containing the emulated (input) data (.meta and .raw)
     * @param locations The set of location to be triggered
     * @param opCode The opCode of the triggered sequencer "main"
     * @param annotation The annotation to be associated with the image
     */
    public TriggerSimulatedImage(String triggeredImageName, String triggeredDAQFolder, String emulatedImageName, String emulatedDAQFolder, String emulatedDataFolder, LocationSet locations, int opCode, String annotation) {
        this.triggeredImageName = triggeredImageName;
        this.triggeredDAQFolder = triggeredDAQFolder;
        this.emulatedImageName = emulatedImageName;
        this.emulatedDAQFolder = emulatedDAQFolder;
        this.emulatedDataFolder = emulatedDataFolder;
        this.locations = locations;
        this.opCode = opCode;
        this.annotation = annotation;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getTriggeredImageName() {
        return triggeredImageName;
    }

    public LocationSet getLocations() {
        return locations;
    }

    public String getAnnotation() {
        return annotation;
    }

    public String getTriggeredDAQFolder() {
        return triggeredDAQFolder;
    }

    public String getEmulatedImageName() {
        return emulatedImageName;
    }

    public String getEmulatedDAQFolder() {
        return emulatedDAQFolder;
    }

    public String getEmulatedDataFolder() {
        return emulatedDataFolder;
    }

    public int getOpCode() {
        return opCode;
    }

    @Override
    public String toString() {
        return "TriggerSimulatedImage{" + "triggeredImageName=" + triggeredImageName + ", locations=" + locations + ", annotation=" + annotation + ", triggeredDAQFolder=" + triggeredDAQFolder + ", emulatedImageName=" + emulatedImageName + ", emulatedDAQFolder=" + emulatedDAQFolder + ", emulatedDataFolder=" + emulatedDataFolder + '}';
    }

    
}
