package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;

/**
 * An AdditionalFile with data to be written as text.
 * @author tonyj
 */
@SkipEncoding
public class TextFile extends AdditionalFile {
    
    private final String text;
    private final String commentDelimiter;
    private final boolean includeStandardHeader;
    private static final long serialVersionUID = 1;

    public TextFile(String text, String fileName, String fileType, ImageName obsId) {
        this(text, "#", true, fileName, fileType, obsId);
    }

    public TextFile(String text, String commentDelimiter, boolean includeStandardHeader, String fileName, String fileType, ImageName obsId) {
        super(fileName, fileType, obsId);
        this.text = text;
        this.commentDelimiter = commentDelimiter;
        this.includeStandardHeader = includeStandardHeader;
    }   

    @Override
    public void writeFile(OutputStream out) throws IOException {
        try (PrintStream ps = new PrintStream(out)) {
            if (includeStandardHeader) {
                ps.println(commentDelimiter);
                ps.printf("%s ObsId: %s\n", commentDelimiter, getObsId());
                ps.printf("%s FileName: %s\n", commentDelimiter, getFileName());
                ps.printf("%s FileType: %s\n", commentDelimiter, getFileType());
                ps.println(commentDelimiter);
            }
            ps.print(text);
        }
        
    }
    
}
