/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;

public class FileListTest {
    @Test
    public void testGetCommonParentDirectory() {
        FileList fl = new FileList();
        fl.add((Object)new File("/tmp/a/b"));
        fl.add((Object)new File("/tmp/a/c.txt"));
        Assert.assertEquals((Object)new File("/tmp/a"), (Object)fl.getCommonParentDirectory());
        Assert.assertEquals((Object)"2 files: /tmp/a [b, c.txt]", (Object)fl.toString());
    }

    @Test
    public void badPixelTest() {
        FileList fl = new FileList();
        fl.add((Object)new File("/tmp/a/b"));
        fl.addBadPixels(5);
        fl.add((Object)new File("/tmp/a/c.txt"));
        fl.addBadPixels(10);
        Assert.assertEquals((Object)new File("/tmp/a"), (Object)fl.getCommonParentDirectory());
        Assert.assertEquals((Object)"2 files (15 bad pixels): /tmp/a [b, c.txt]", (Object)fl.toString());
        Assert.assertEquals((long)15L, (long)fl.getBadPixelCount());
        FileList fl2 = new FileList();
        fl2.addAll(fl);
        Assert.assertEquals((Object)new File("/tmp/a"), (Object)fl2.getCommonParentDirectory());
        Assert.assertEquals((long)15L, (long)fl2.getBadPixelCount());
    }

    @Test
    public void deserializeOldFileListObject() throws IOException, ClassNotFoundException {
        URL resource = FileListTest.class.getResource("filelist.ser");
        System.out.println(resource);
        try (ObjectInputStream ois = new ObjectInputStream(resource.openStream());){
            FileList fl = (FileList)ois.readObject();
            Assert.assertEquals((long)0L, (long)fl.getBadPixelCount());
        }
    }
}

