package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.daq.ims.ImageMetaData;

/**
 * An event sent when an Image has been received.
 * 
 * @author The LSSTCCS Team
 */
@SkipEncoding
public class ImageReceivedEvent implements Serializable {
    
    private static final long serialVersionUID = 895129346334L;
    
    public static final String EVENT_KEY = "imageReceivedEvent";

    private final ImageMetaData imageMetaData;
    
    public ImageReceivedEvent(ImageMetaData imageMetaData) {
        this.imageMetaData = imageMetaData;
    }

    public String getImageName() {
        return imageMetaData.getName();
    }
    
    public ImageMetaData getImageMetaData() {
        return imageMetaData;
    }
}
