package org.lsst.ccs.subsystem.imagehandling.states;

/**
 * A state for each of the rebs monitored by the ImageHandling subsystem.
 * This state is a component state at the Reb level.
 * 
 * @author The LSST CCS Team
 */
public enum ImageHandlingState {
    /** 
     * The corresponding reb is disabled and no data is written for it 
     **/
    DISABLED, 
    /**
     * Waiting for data
     */
    IDLE, 
    /** 
     * Reading data
     */
    READING, 
    /**
     * Streaming data
     */
    STREAMING; 
}
