/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.daq.guider.ClearParameters;
import org.lsst.ccs.daq.guider.Config;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROICommonExtended;
import org.lsst.ccs.daq.guider.ROISpec;
import org.lsst.ccs.daq.guider.SeriesStatus;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Guider;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.GuidingState;
import org.lsst.ccs.utilities.location.SensorLocationSet;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public final class Guiding {
    private static final Logger LOG = Logger.getLogger(Guiding.class.getName());
    private static final Map<Status.State, GuidingState> stateMap = Map.of(Status.State.IDLECLEARING, GuidingState.IDLECLEARING, Status.State.SLEEPING, GuidingState.SLEEPING, Status.State.ERROR, GuidingState.ERROR, Status.State.PAUSED, GuidingState.PAUSED, Status.State.RUNNING, GuidingState.RUNNING, Status.State.UNDEFINED, GuidingState.UNDEFINED, Status.State.CLEARING, GuidingState.CLEARING, Status.State.IDLEPAUSE, GuidingState.IDLEPAUSE);
    private final SequencerConfig sequencerConfig;
    private final AgentStateService agentStateService;
    private final Scheduler pauseTimeoutScheduler;
    private volatile ROISpec roiSpec;
    private static final SensorLocationSet NO_SENSORS = new SensorLocationSet();
    private ScheduledFuture<Object> scheduledPauseTimeout;
    private CompletableFuture<Void> readoutActive;

    public Guiding(SequencerConfig config, AgentStateService agentStateService, Scheduler pauseTimeoutScheduler) {
        this.sequencerConfig = config;
        this.agentStateService = agentStateService;
        this.pauseTimeoutScheduler = pauseTimeoutScheduler;
        boolean hasGuiderPartition = this.sequencerConfig.hasGuiderPartition();
        if (hasGuiderPartition) {
            try {
                Status.State out = this.sequencerConfig.getGuider().series().getStatus().getOut();
                this.updateState(out);
                if (out != Status.State.IDLECLEARING && out != Status.State.SLEEPING) {
                    this.stopGuiding();
                }
            }
            catch (DAQException x) {
                LOG.log(Level.SEVERE, "Error initializing guider state", x);
                agentStateService.updateAgentState(new Enum[]{GuidingState.UNDEFINED});
            }
        } else {
            agentStateService.updateAgentState(new Enum[]{GuidingState.UNDEFINED});
        }
    }

    private void updateState(Status.State state) {
        LOG.log(Level.INFO, "Initial guiding state {0}", state);
        this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(state)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initGuiders(String roiSpec) throws DAQException {
        Guiding guiding = this;
        synchronized (guiding) {
            this.roiSpec = ROISpec.parse((String)roiSpec);
        }
        Guider guider = this.sequencerConfig.getGuider();
        SeriesStatus series = guider.series();
        Status.State out = series.getStatus().getOut();
        switch (out) {
            case SLEEPING: {
                guider.wake(this.sequencerConfig.getGuiderIdleClearParameters());
                break;
            }
            case ERROR: {
                this.recoverFromErrorBeforeInitGuiders(guider);
                break;
            }
            case PAUSED: {
                LOG.log(Level.WARNING, "Accepting initGuiders when guiders already in PAUSED state");
            }
        }
        ROICommonExtended rce = new ROICommonExtended(this.roiSpec.getCommon(), this.sequencerConfig.getExtendedROIParameters());
        Status status = guider.start((ROICommon)rce, this.roiSpec.getLocations());
        this.checkStatusAfterCommand(status, GuidingState.PAUSED);
        this.schedulePauseTimeout();
    }

    private void schedulePauseTimeout() {
        long guiderPauseTimeout = this.sequencerConfig.getGuiderPauseTimeout();
        if (guiderPauseTimeout > 0L) {
            this.scheduledPauseTimeout = this.pauseTimeoutScheduler.schedule(() -> {
                Object object = this.agentStateService.getStateLock();
                synchronized (object) {
                    this.scheduledPauseTimeout = null;
                    if (this.agentStateService.isInState((Enum)GuidingState.PAUSED)) {
                        LOG.log(Level.WARNING, "Guider pause timeout triggered");
                        this.stopGuiding();
                    }
                }
                return null;
            }, guiderPauseTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelPauseTimeout() {
        ScheduledFuture<Object> timeout = this.scheduledPauseTimeout;
        if (timeout != null) {
            this.scheduledPauseTimeout = null;
            timeout.cancel(false);
        }
    }

    int validate(String roiSpec) throws DAQException {
        ROISpec spec = ROISpec.parse((String)roiSpec);
        Guider guider = this.sequencerConfig.getGuider();
        spec.sanityCheck(guider.getConfiguredLocations());
        spec.sanityCheckWithSensorLocations(this.sequencerConfig.getGuiderLocations());
        ROICommon common = spec.getCommon();
        guider.validate(common, spec.getLocations());
        int rows = common.getRows();
        int cols = common.getCols();
        int ns = 32751760 + 490700 * rows + 1030 * cols * rows;
        return common.getIntegrationTimeMillis() + ns / 1000000;
    }

    void resumeGuiding(String imageName) throws DAQException {
        this.cancelPauseTimeout();
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.resume(imageName);
            this.checkStatusAfterCommand(status, GuidingState.RUNNING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    int pauseGuiding() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.pause();
            this.checkStatusAfterCommand(status, GuidingState.PAUSED);
            this.schedulePauseTimeout();
            int stamps = guider.series().getSeries().getStamps();
            return stamps;
        }
        catch (DAQException x) {
            Status.State in = guider.series().getStatus().getIn();
            if (in == Status.State.ERROR) {
                this.recoverFromErrorBeforePause(guider);
                return 0;
            }
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    private void recoverFromErrorBeforePause(Guider guider) throws DAQException {
        try {
            SeriesStatus series = guider.series();
            LOG.log(Level.WARNING, "Attempting to recover from ERROR before pause, transitioning to IDLECLEARING, previous state {0}", series);
            Status status = guider.stop();
            this.checkStatusAfterCommand(status, GuidingState.IDLECLEARING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    private void recoverFromErrorBeforeInitGuiders(Guider guider) throws DAQException {
        try {
            SeriesStatus series = guider.series();
            LOG.log(Level.WARNING, "Attempting to recover from ERROR before initGuiders, transitioning to IDLECLEARING, previous state {0}", series);
            Status status = guider.stop();
            this.checkStatusAfterCommand(status, GuidingState.IDLECLEARING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    void pauseDuringReadout() throws DAQException {
        boolean isSleeping = this.agentStateService.isInState((Enum)GuidingState.SLEEPING);
        if (isSleeping) {
            return;
        }
        if (this.isROISet()) {
            this.readoutActive = new CompletableFuture();
        } else {
            Guider guider = this.sequencerConfig.getGuider();
            try {
                Status status = guider.pause();
                this.checkStatusAfterCommand(status, GuidingState.IDLEPAUSE);
            }
            catch (DAQException x) {
                Status.State out = guider.series().getStatus().getOut();
                this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
                throw x;
            }
        }
    }

    void resumeAfterReadout() throws DAQException {
        boolean isSleeping = this.agentStateService.isInState((Enum)GuidingState.SLEEPING);
        if (isSleeping) {
            return;
        }
        boolean isInIdlePause = this.agentStateService.isInState((Enum)GuidingState.IDLEPAUSE);
        if (isInIdlePause) {
            Guider guider = this.sequencerConfig.getGuider();
            try {
                Status status = guider.resume();
                this.checkStatusAfterCommand(status, GuidingState.IDLECLEARING);
            }
            catch (DAQException x) {
                Status.State out = guider.series().getStatus().getOut();
                this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
                throw x;
            }
        } else {
            CompletableFuture<Void> localReadout = this.readoutActive;
            if (localReadout != null) {
                localReadout.complete(null);
                this.readoutActive = null;
            }
        }
    }

    boolean isROISet() {
        return this.roiSpec != null;
    }

    void stopGuidingOnceReadoutComplete() throws DAQException {
        CompletableFuture<Void> localReadout = this.readoutActive;
        if (localReadout != null) {
            this.roiSpec = null;
            LOG.log(Level.INFO, "Scheduling stopGuiding after readout complete");
            localReadout.thenRun(() -> {
                try {
                    Guiding guiding = this;
                    synchronized (guiding) {
                        if (this.isROISet()) {
                            LOG.log(Level.INFO, "Scheduled stopGuiding skipped, because roiSpec was set");
                        } else {
                            this.stopGuiding();
                            LOG.log(Level.INFO, "Scheduled stopGuiding done");
                        }
                    }
                }
                catch (DAQException x) {
                    LOG.log(Level.SEVERE, "Scheduled stopGuiding failed", x);
                }
            });
        } else {
            this.stopGuiding();
        }
    }

    void stopGuiding() throws DAQException {
        this.cancelPauseTimeout();
        this.roiSpec = null;
        Guider guider = this.sequencerConfig.getGuider();
        Status.State out = guider.series().getStatus().getOut();
        if (out != Status.State.SLEEPING && out != Status.State.UNDEFINED && out != Status.State.IDLECLEARING) {
            try {
                Status status = guider.stop();
                this.checkStatusAfterCommand(status, GuidingState.IDLECLEARING);
            }
            catch (DAQException x) {
                out = guider.series().getStatus().getOut();
                this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
                throw x;
            }
        } else {
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
        }
    }

    SensorLocationSet getSensors() {
        return this.roiSpec == null ? NO_SENSORS : this.roiSpec.getSensorLocations();
    }

    void sleepGuider() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.sleep();
            this.checkStatusAfterCommand(status, GuidingState.SLEEPING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    void wakeGuider() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.wake(this.sequencerConfig.getGuiderIdleClearParameters());
            this.checkStatusAfterCommand(status, GuidingState.IDLECLEARING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    void clearGuider(ClearParameters clearParameters) throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.clear(clearParameters);
            this.checkStatusAfterCommand(status, GuidingState.CLEARING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    SeriesStatus series() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        return guider.series();
    }

    Config config() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        return guider.config();
    }

    private void checkCurrentStatus(GuidingState expectedState) {
        StateBundle currentState = this.agentStateService.getState();
        if (!currentState.isInState((Enum)expectedState)) {
            throw new RuntimeException("Guider in unexpected state, expected=" + expectedState + " actual=" + currentState.getState(GuidingState.class));
        }
    }

    private void checkStatusAfterCommand(Status status, GuidingState expectedState) {
        GuidingState newState = this.mapStateToGuidingState(status.getOut());
        this.agentStateService.updateAgentState(new Enum[]{newState});
        if (newState != expectedState) {
            throw new RuntimeException("Guider entered unexpected state, expected=" + expectedState + " actual=" + newState);
        }
    }

    private GuidingState mapStateToGuidingState(Status.State state) {
        return stateMap.getOrDefault(state, GuidingState.UNDEFINED);
    }
}

