/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.subsystem.focalplane.IdleClear;
import org.lsst.ccs.subsystem.focalplane.IdleClearSupport;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.TestSequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class IdleClearTest {
    private DummySequencers dummySequencers;
    private SequencerConfig sequencerConfig;
    private IdleClear idleClear;

    @Before
    public void setup() throws REBException {
        this.sequencerConfig = TestSequencerConfig.getDefaultConfig();
        this.dummySequencers = new DummySequencers();
        this.idleClear = new IdleClear(this.sequencerConfig, null, (IdleClearSupport)this.dummySequencers);
    }

    @Test
    public void testBasicIdleClear() throws IOException, RaftException, REBException, DAQException, InterruptedException {
        this.dummySequencers.nIdleClear = new CountDownLatch(10);
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
        this.idleClear.startPeriodicTask();
        this.dummySequencers.nIdleClear.await();
        Assert.assertNotNull((Object)this.idleClear.getIdleClearPeriodicTask());
        this.idleClear.endIdleClear(null);
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
        Assert.assertEquals((long)1L, (long)this.dummySequencers.nPrepare);
        Assert.assertEquals((long)1L, (long)this.dummySequencers.nTerminate);
        Assert.assertEquals((long)0L, (long)this.dummySequencers.nIdleClear.getCount());
    }

    @Test
    public void testPauseIdleClear() throws IOException, RaftException, REBException, DAQException, InterruptedException {
        this.dummySequencers.nIdleClear = new CountDownLatch(5);
        this.idleClear.startPeriodicTask();
        Assert.assertNotNull((Object)this.idleClear.getIdleClearPeriodicTask());
        this.dummySequencers.nIdleClear.await();
        this.dummySequencers.nIdleClear = new CountDownLatch(5);
        this.idleClear.commandedPauseIdleClear(Duration.ofSeconds(3L));
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
        Thread.sleep(2000L);
        Assert.assertEquals((long)5L, (long)this.dummySequencers.nIdleClear.getCount());
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
        this.dummySequencers.nIdleClear.await();
        this.idleClear.endIdleClear(null);
        Assert.assertEquals((long)2L, (long)this.dummySequencers.nPrepare);
        Assert.assertEquals((long)2L, (long)this.dummySequencers.nTerminate);
        Assert.assertEquals((long)0L, (long)this.dummySequencers.nIdleClear.getCount());
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
    }

    @Test
    public void testPauseWithRestartIdleClear() throws IOException, RaftException, REBException, DAQException, InterruptedException {
        this.dummySequencers.nIdleClear = new CountDownLatch(5);
        this.idleClear.startPeriodicTask();
        this.dummySequencers.nIdleClear.await();
        this.dummySequencers.nIdleClear = new CountDownLatch(5);
        this.idleClear.commandedPauseIdleClear(Duration.ofSeconds(100L));
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
        Thread.sleep(2000L);
        Assert.assertEquals((long)5L, (long)this.dummySequencers.nIdleClear.getCount());
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
        this.idleClear.commandedStartIdleClear();
        Assert.assertNotNull((Object)this.idleClear.getIdleClearPeriodicTask());
        this.dummySequencers.nIdleClear.await();
        this.idleClear.endIdleClear(null);
        Assert.assertEquals((long)2L, (long)this.dummySequencers.nPrepare);
        Assert.assertEquals((long)2L, (long)this.dummySequencers.nTerminate);
        Assert.assertEquals((long)0L, (long)this.dummySequencers.nIdleClear.getCount());
        Assert.assertNull((Object)this.idleClear.getIdleClearPeriodicTask());
    }

    private static class DummySequencers
    implements IdleClearSupport {
        private CountDownLatch nIdleClear;
        private int nPrepare = 0;
        private int nTerminate = 0;

        private DummySequencers() {
        }

        public void doIdleClear() throws REBException, RaftException, DAQException {
            this.nIdleClear.countDown();
        }

        public void prepareForIdleClear() throws REBException, RaftException, DAQException {
            ++this.nPrepare;
        }

        public void terminateIdleClear(FocalPlaneState stateOnFinish) throws REBException, RaftException, DAQException {
            ++this.nTerminate;
        }
    }
}

