/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Set;
import java.util.TreeSet;
import org.lsst.ccs.drivers.reb.sim.RegisterSet;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class AddressSpace {
    private final Set<RegisterSet> addressSpace = new TreeSet<RegisterSet>((o1, o2) -> o1.baseAddress() - o2.baseAddress());

    void add(RegisterSet rs) {
        this.addressSpace.add(rs);
    }

    private RegisterSet mapAddress(int address) {
        for (RegisterSet rs : this.addressSpace) {
            if (rs.baseAddress() + rs.length() <= address) continue;
            if (rs.baseAddress() > address) break;
            return rs;
        }
        throw new SimulationException("Address 0x%08x not found in address space", address);
    }

    void readRegs(int address, int[] values, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            values[i + offset] = this.read(address + i);
        }
    }

    void writeRegs(int address, int[] values, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            this.write(address + i, values[i + offset]);
        }
    }

    public int read(int address) {
        return this.mapAddress(address).read(address);
    }

    public void write(int address, int value) {
        this.mapAddress(address).write(address, value);
    }

    public void hexDump(PrintStream pw, int start, int end) {
        for (RegisterSet rs : this.addressSpace) {
            if (rs.baseAddress() > end) break;
            if (rs.baseAddress() + rs.length() <= start) continue;
            int[] buffer = new int[8];
            for (int row = Math.max(start, rs.baseAddress()); row < rs.baseAddress() + rs.length(); row += buffer.length) {
                boolean allZero = true;
                for (int address = row; address < end && address - row < buffer.length; ++address) {
                    try {
                        int value = this.read(address);
                        allZero &= value == 0;
                        buffer[address - row] = value;
                        continue;
                    }
                    catch (SimulationException x) {
                        buffer[address - row] = 0;
                    }
                }
                if (allZero) continue;
                pw.printf("%08x: ", row);
                for (int value : buffer) {
                    pw.printf("%08x ", value);
                }
                pw.println();
            }
        }
    }

    public void hexLoad(Reader reader) throws IOException {
        try (BufferedReader in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            in.lines().forEach(line -> {
                String[] tokens = line.split(":?\\s+");
                if (tokens.length < 2) {
                    throw new SimulationException("Bad syntax for hex file at line\n\t" + line);
                }
                int address = Integer.parseInt(tokens[0], 16);
                for (int i = 1; i < tokens.length; ++i) {
                    this.write(address++, Integer.parseUnsignedInt(tokens[i], 16));
                }
            });
        }
    }
}

