/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.server;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.visualization.client.DataMessage;
import org.lsst.ccs.visualization.client.HeaderMessage;
import org.lsst.ccs.visualization.client.Message;
import org.lsst.ccs.visualization.client.StartMessage;
import org.lsst.ccs.visualization.server.FitsFileHandler;

class FitsFileHandlerImpl
implements FitsFileHandler {
    private static final int MAX_CARDS_PER_HEADER = 36;
    private final BufferedFile bf;
    private final Header header;
    private final long dataPointer;
    private final File file;
    private final int nHeaders;
    private static final Logger logger = Logger.getLogger(FitsFileHandlerImpl.class.getName());

    FitsFileHandlerImpl(File dir, StartMessage start) throws IOException {
        try {
            this.file = new File(dir, start.getImageName() + ".fits");
            this.bf = new BufferedFile(this.file, "rw");
            BasicHDU primary = BasicHDU.getDummyHDU();
            this.header = primary.getHeader();
            this.header.setNaxis(1, start.getWidth());
            this.header.setNaxis(2, start.getHeight());
            primary.addValue((IFitsHeader)Standard.BITPIX, 32);
            primary.addValue((IFitsHeader)Standard.NAXIS, 2);
            this.header.write((ArrayDataOutput)this.bf);
            this.nHeaders = start.getnHeaders();
            long filePointer = this.bf.getFilePointer();
            int extraBlocks = (start.getnHeaders() + this.header.getNumberOfPhysicalCards() + 35) / 36 - 1;
            this.dataPointer = filePointer + (long)(extraBlocks * 2880);
            logger.log(Level.INFO, String.format("nHeaders=%d extraBlocks=%d physicalCards=%d MAX_CARDS_PER_HEADER=%d", this.nHeaders, extraBlocks, this.header.getNumberOfPhysicalCards(), 36));
            logger.log(Level.INFO, String.format("dataPointer=%d", this.dataPointer));
            long imageSize = 4 * start.getWidth() * start.getHeight();
            this.bf.seek(this.dataPointer + imageSize);
            FitsUtil.pad((ArrayDataOutput)this.bf, (long)imageSize);
            logger.log(Level.INFO, "Created {0} imagesize={1} nClients={2} nHeaders={3}", new Object[]{this.file, imageSize, start.getnClients(), start.getnHeaders()});
        }
        catch (FitsException fx) {
            throw new IOException("Fits error during IO", fx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Message msg, SocketChannel socket) throws IOException {
        switch (msg.getType()) {
            case DATA: {
                DataMessage data = (DataMessage)msg;
                FileChannel channel = this.bf.getChannel();
                if (data.getStepLength() == 0) {
                    channel.transferFrom(socket, this.dataPointer + (long)(4 * data.getOffset()), data.getDataLength());
                    break;
                }
                int stepLength = data.getStepLength();
                int stepOffset = data.getStepOffset();
                long position = this.dataPointer + (long)(4 * data.getOffset());
                for (int limit = data.getDataLength(); limit > 0; limit -= 4 * stepLength) {
                    channel.transferFrom(socket, position, 4 * stepLength);
                    position += (long)(4 * stepOffset);
                }
                break;
            }
            case HEADER: {
                HeaderMessage hdr = (HeaderMessage)msg;
                Header header = this.header;
                synchronized (header) {
                    this.header.addLine(HeaderCard.create((String)hdr.getCard()));
                    break;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.bf.seek(0L);
            logger.log(Level.INFO, String.format("Received %d/%d headers", this.header.getNumberOfCards(), this.nHeaders));
            this.header.write((ArrayDataOutput)this.bf);
            logger.log(Level.INFO, String.format("File Pointer after writing headers %d", this.bf.getFilePointer()));
            this.bf.close();
            logger.log(Level.INFO, "Closed {0}", this.file);
        }
        catch (FitsException fx) {
            throw new IOException("Fits error during IO", fx);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    static {
        FitsFactory.setUseHierarch((boolean)true);
    }
}

