/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.EventSender;
import org.lsst.ccs.subsystem.focalplane.ExpectedSensorsEventSender;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.location.SensorLocationSet;

public class ExpectedSensorsEventSenderTest {
    @Test
    public void testEventSender() {
        TestEventSender sender = new TestEventSender();
        ExpectedSensorsEventSender ees = new ExpectedSensorsEventSender((EventSender)sender);
        ImageName imageName = new ImageName("MC_C_20230521_000001");
        ees.startIntegration(imageName, LocationSet.of((String[])new String[]{"R22"}));
        ees.startGuiding(imageName, SensorLocationSet.of((String)"R00SG1,R00SG0"));
        ees.stopGuiding();
        ees.endIntegration(LSE71Commands.ReadoutMode.TRUE);
        Assert.assertEquals((Object)"additionalFile", (Object)sender.getKey());
        Assert.assertTrue((boolean)(sender.getEvent() instanceof JsonFile));
        Assert.assertEquals((Object)"{\n  \"fileName\" : \"MC_C_20230521_000001_expectedSensors.json\",\n  \"fileType\" : \"expectedSensors\",\n  \"obsId\" : \"MC_C_20230521_000001\",\n  \"expectedSensors\" : {\n    \"R00_SG0\" : \"GUIDER\",\n    \"R00_SG1\" : \"GUIDER\",\n    \"R22_S00\" : \"SCIENCE\",\n    \"R22_S01\" : \"SCIENCE\",\n    \"R22_S02\" : \"SCIENCE\",\n    \"R22_S10\" : \"SCIENCE\",\n    \"R22_S11\" : \"SCIENCE\",\n    \"R22_S12\" : \"SCIENCE\",\n    \"R22_S20\" : \"SCIENCE\",\n    \"R22_S21\" : \"SCIENCE\",\n    \"R22_S22\" : \"SCIENCE\"\n  }\n}", (Object)sender.getEvent().toString());
    }

    @Test
    public void testEventSenderForWavefront() {
        TestEventSender sender = new TestEventSender();
        ExpectedSensorsEventSender ees = new ExpectedSensorsEventSender((EventSender)sender);
        ImageName imageName = new ImageName("MC_C_20230521_000001");
        ees.startIntegration(imageName, LocationSet.of((String[])new String[]{"R00/RebW"}));
        ees.endIntegration(LSE71Commands.ReadoutMode.TRUE);
        Assert.assertEquals((Object)"additionalFile", (Object)sender.getKey());
        Assert.assertTrue((boolean)(sender.getEvent() instanceof JsonFile));
        Assert.assertEquals((Object)"{\n  \"fileName\" : \"MC_C_20230521_000001_expectedSensors.json\",\n  \"fileType\" : \"expectedSensors\",\n  \"obsId\" : \"MC_C_20230521_000001\",\n  \"expectedSensors\" : {\n    \"R00_SW0\" : \"SCIENCE\",\n    \"R00_SW1\" : \"SCIENCE\"\n  }\n}", (Object)sender.getEvent().toString());
    }

    private static class TestEventSender
    implements EventSender {
        private String key;
        private Serializable event;

        private TestEventSender() {
        }

        public void sendEvent(String key, Serializable event) {
            this.key = key;
            this.event = event;
        }

        public String getKey() {
            return this.key;
        }

        public Serializable getEvent() {
            return this.event;
        }
    }
}

