package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

/**
 * Subset of sequencer functionality needed to test idle clear
 * @author tonyj
 */
public interface IdleClearSupport {

    void doIdleClear() throws REBException, RaftException, DAQException;

    /**
     * Puts the sequencers into IDLE_CLEAR state.
     *
     * @throws REBException
     * @throws RaftException
     * @throws DAQException
     */
    void prepareForIdleClear() throws REBException, RaftException, DAQException;

    /**
     * Stops the sequencers, which must be in IDLE_CLEAR mode.
     * This method does not return until the idle clear is complete.
     *
     * @param stateOnFinish The state to go to, or null to leave the state
     * unchanged.
     * @throws REBException
     * @throws RaftException
     * @throws DAQException
     */
    void terminateIdleClear(FocalPlaneState stateOnFinish) throws REBException, RaftException, DAQException;
    
}
